<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */
 
class Sku_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get sku by sku_id
     */
    function get_sku($sku_id)
    {
        return $this->db->get_where('sku',array('sku_id'=>$sku_id))->row_array();
    }
        
    /*
     * Get all sku
     */
    function get_all_skus()
    {
        $this->db->order_by('sku_id', 'desc');
        return $this->db->get('sku')->result_array();
    }
    
    function get_all_skus_by_produto_id($produto_id)
    {
        $this->db->select('sku.sku_id, cor.hexa, tamanho.descricao as tamanho, cor.descricao as cor, sku.saldo as saldo, sku.status as status');
        $this->db->where('produto_id', $produto_id);
        $this->db->join('tamanho', 'sku.tamanho_id = tamanho.tamanho_id');
        $this->db->join('cor', 'cor.cor_id = sku.cor_id');
        $this->db->join('ordenacao', 'tamanho.descricao= ordenacao.tamanho');
        $this->db->order_by('cor.descricao, ordenacao.ordem', 'asc');
        return $this->db->get('sku')->result_array();
    }
    
    
    function check_sku($produto_id, $cor_id, $tamanho_id)
    {
        
        $this->db->where('produto_id', $produto_id);
        $this->db->where('cor_id', $cor_id);
        $this->db->where('tamanho_id', $tamanho_id);
        return $this->db->get('sku')->result_array();
    }
    
    
        
    /*
     * function to add new sku
     */
    function add_sku($params)
    {
        $this->db->insert('sku',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update sku
     */
    function update_sku($sku_id,$params)
    {
        $this->db->where('sku_id',$sku_id);
        return $this->db->update('sku',$params);
    }
    
    /*
     * function to delete sku
     */
    function delete_sku($sku_id)
    {
        return $this->db->delete('sku',array('sku_id'=>$sku_id));
    }
}
