<?php
 
class Produto_pedido_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get produto_pedido by produto_pedido_id
     */
    function get_produto_pedido($produto_pedido_id)
    {
        return $this->db->get_where('produto_pedido',array('produto_pedido_id'=>$produto_pedido_id))->row_array();
    }
        
    /*
     * Get all produto_pedido
     */
    function get_all_produto_pedido()
    {
        $this->db->order_by('produto_pedido_id', 'desc');
        return $this->db->get('produto_pedido')->result_array();
    }
    
    
    function get_all_produtos_by_pedido_id($pedido_id)
    {
	
		$dbportal = $this->load->database('portal',TRUE);
        $dbportal->select('produto_pedido.produto_id, produto.ref, produto.cashback, produto.nome, produto_pedido.preco, sum(produto_pedido.qtd) as qtd');
        $dbportal->where('pedido_id', $pedido_id);
		$dbportal->where('produto_pedido.qtd > 0');
		
        $dbportal->join('produto', 'produto_pedido.produto_id = produto.produto_id');
		$dbportal->group_by('produto_pedido.produto_id, produto.ref, produto.nome,  produto_pedido.preco');
        return $dbportal->get('produto_pedido')->result_array();
		
		
		/*
        $this->db->select('produto_pedido.produto_id, produto.ref, produto.nome, sum(produto_pedido.qtd) as qtd, sum(produto_pedido.preco) as preco, sum(produto_pedido.total) as total');
        $this->db->where('pedido_id', $pedido_id);
        $this->db->join('produto', 'produto_pedido.produto_id = produto.produto_id');
		$this->db->group_by('produto_pedido.produto_id, produto.ref, produto.nome');
        return $this->db->get('produto_pedido')->result_array();
		*/
    }
    
        
    /*
     * function to add new produto_pedido
     */
    function add_produto_pedido($params)
    {
        $this->db->insert('produto_pedido',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update produto_pedido
     */
    function update_produto_pedido($produto_pedido_id,$params)
    {
        $this->db->where('produto_pedido_id',$produto_pedido_id);
        return $this->db->update('produto_pedido',$params);
    }
    
    /*
     * function to delete produto_pedido
     */
    function delete_produto_pedido($produto_pedido_id)
    {
        return $this->db->delete('produto_pedido',array('produto_pedido_id'=>$produto_pedido_id));
    }
}
