<?php
 
class Produto_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    function get_produtos_totvs(){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "select B1_COD, B1_DESC,  B1_ZZLINH1, B1_ZZLINH2, B1_ZZCSHBC, B1_ZZQTWEB, B1_MSBLQL, B1_GRUPO   from SB1010 SB1 (NOLOCK)
					where SB1.D_E_L_E_T_ = ' '
					AND B1_TIPO in ('PA','OI')
					AND (B1_ZZLINH1 <> '' OR B1_ZZLINH2 <> '')
        ";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function gera_cashback(){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "
			-- Primeira consulta como subquery
WITH DOC_SAIDAS AS (
    SELECT  
        D2_FILIAL AS FILIAL, 
        D2_CLIENTE,
		A1_NOME AS NOME,
		A1_NREDUZ AS NOME_REDUZ, 
        D2_LOJA, 
        SUM(D2_TOTAL) AS VLR_FAT, 
		SUM(D2_TOTAL * D2_ZZCHBCK / 100.0) AS CASHBACK,
        D2_PEDIDO AS PEDIDO, 
        D2_DOC AS DOCUMENTO,  
		D2_SERIE AS SERIE,
		CONVERT(VARCHAR,CONVERT(DATE,D2_EMISSAO),103) AS DT_FAT, IIF(F4_DUPLIC = 'S', 'DUPLICATA','BONIFICACAO') AS TIPO_PV
    FROM SD2010 SD2  WITH (NOLOCK)
	INNER JOIN SA1010 SA1 WITH (NOLOCK) ON A1_COD = D2_CLIENTE AND A1_LOJA = D2_LOJA
	INNER JOIN SB1010 SB1 WITH (NOLOCK) ON B1_COD = D2_COD
	INNER JOIN SF4010 SF4 WITH (NOLOCK) ON F4_CODIGO = D2_TES AND F4_FILIAL = '01'
    WHERE SD2.D_E_L_E_T_ = ' '  AND SA1.D_E_L_E_T_ = ' ' AND SF4.D_E_L_E_T_ = ' ' AND SB1.D_E_L_E_T_ = ' '
    AND D2_FILIAL =  '0102'
    AND D2_EMISSAO >= '20250313'
    GROUP BY D2_FILIAL, D2_CLIENTE, D2_LOJA, D2_PEDIDO, D2_DOC, D2_EMISSAO, A1_NOME, A1_NREDUZ, F4_DUPLIC, D2_SERIE
),
-- Segunda consulta como subquery
ORCAMENTO AS (
    SELECT DISTINCT 
		CK_CLIENTE, 
		CK_LOJA,
        CK_NUM AS ORCAMENTO, 
        CK_NUMPV AS PEDIDO, 
		CONVERT(VARCHAR,CONVERT(DATE,CJ_EMISSAO),103) AS DT_ORC,
        CJ_ZZIDWEB,  
		CJ_VEND1 AS VENDEDOR,
		SUM(CK_VALOR) AS VLR_ORC
    FROM SCK010 SCK WITH (NOLOCK)
    INNER JOIN SCJ010 SCJ  WITH (NOLOCK)
        ON CJ_NUM = CK_NUM 
       AND CJ_CLIENTE = CK_CLIENTE 
       AND CJ_LOJA = CK_LOJA
    WHERE SCK.D_E_L_E_T_ = ' ' 
      AND SCJ.D_E_L_E_T_ = ' ' 
	  AND SCJ.CJ_ZZIDWEB >= '20000'
	  AND SCJ.CJ_ZZIDWEB <> ''
	-- AND CJ_EMISSAO >= '20250313'
	  AND CK_FILENT = '0102' AND CK_FILVEN = '0102'
	  GROUP BY CK_NUM, CK_NUMPV, CJ_ZZIDWEB,  CJ_VEND1, CJ_EMISSAO, CK_CLIENTE, CK_LOJA
	  )

-- Realizando o INNER JOIN entre as duas consultas
SELECT 
    SD2.FILIAL, 
    SD2.D2_CLIENTE,
	SD2.D2_LOJA,
	SD2.NOME,
	SD2.NOME_REDUZ,
	SCK.CJ_ZZIDWEB,
    SCK.ORCAMENTO,
	SCK.VLR_ORC,
	SCK.DT_ORC,
	SD2.PEDIDO,
	SD2.DOCUMENTO,
	SD2.SERIE,
    SD2.VLR_FAT, 
	SD2.DT_FAT,
    SD2.CASHBACK,
	SD2.TIPO_PV,
	SCK.VENDEDOR
FROM 
    DOC_SAIDAS SD2
INNER JOIN 
    ORCAMENTO SCK
ON 
    SD2.PEDIDO = SCK.PEDIDO 
	WHERE CASHBACK <> '0'
	AND TIPO_PV = 'DUPLICATA'
	--AND DT_ORC  >= '13/03/2025' 
	--AND DT_ORC <= '21/03/2025'
	--AND ORCAMENTO = '115158'
	--AND CJ_ZZIDWEB = '20423'
    --AND D2_CLIENTE = '000175'
	--AND DOCUMENTO = '000013592'
	--AND DT_FAT = '31/03/2025'
	--AND D2_CLIENTE = '000175'
	ORDER BY   DT_FAT
        ";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function gera_cashback_individual($documento){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "
			-- Primeira consulta como subquery
			WITH DOC_SAIDAS AS (
				SELECT  
					D2_FILIAL AS FILIAL, 
					D2_CLIENTE,
					A1_NOME AS NOME,
					A1_NREDUZ AS NOME_REDUZ, 
					D2_LOJA, 
					SUM(D2_TOTAL) AS VLR_FAT, 
					SUM(D2_TOTAL * D2_ZZCHBCK / 100.0) AS CASHBACK,
					D2_PEDIDO AS PEDIDO, 
					D2_DOC AS DOCUMENTO,  
					D2_SERIE AS SERIE,
					CONVERT(VARCHAR,CONVERT(DATE,D2_EMISSAO),103) AS DT_FAT, IIF(F4_DUPLIC = 'S', 'DUPLICATA','BONIFICACAO') AS TIPO_PV
				FROM SD2010 SD2  WITH (NOLOCK)
				INNER JOIN SA1010 SA1 WITH (NOLOCK) ON A1_COD = D2_CLIENTE AND A1_LOJA = D2_LOJA
				INNER JOIN SB1010 SB1 WITH (NOLOCK) ON B1_COD = D2_COD
				INNER JOIN SF4010 SF4 WITH (NOLOCK) ON F4_CODIGO = D2_TES AND F4_FILIAL = '01'
				WHERE SD2.D_E_L_E_T_ = ' '  AND SA1.D_E_L_E_T_ = ' ' AND SF4.D_E_L_E_T_ = ' ' AND SB1.D_E_L_E_T_ = ' '
				AND D2_FILIAL =  '0102'
				AND D2_EMISSAO >= '20250313'
				GROUP BY D2_FILIAL, D2_CLIENTE, D2_LOJA, D2_PEDIDO, D2_DOC, D2_EMISSAO, A1_NOME, A1_NREDUZ, F4_DUPLIC, D2_SERIE
			),
			-- Segunda consulta como subquery
			ORCAMENTO AS (
				SELECT DISTINCT 
					CK_CLIENTE, 
					CK_LOJA,
					CK_NUM AS ORCAMENTO, 
					CK_NUMPV AS PEDIDO, 
					CONVERT(VARCHAR,CONVERT(DATE,CJ_EMISSAO),103) AS DT_ORC,
					CJ_ZZIDWEB,  
					CJ_VEND1 AS VENDEDOR,
					SUM(CK_VALOR) AS VLR_ORC
				FROM SCK010 SCK WITH (NOLOCK)
				INNER JOIN SCJ010 SCJ  WITH (NOLOCK)
					ON CJ_NUM = CK_NUM 
				   AND CJ_CLIENTE = CK_CLIENTE 
				   AND CJ_LOJA = CK_LOJA
				WHERE SCK.D_E_L_E_T_ = ' ' 
				  AND SCJ.D_E_L_E_T_ = ' ' 
				  AND SCJ.CJ_ZZIDWEB >= '20000'
				  AND SCJ.CJ_ZZIDWEB <> ''
				-- AND CJ_EMISSAO >= '20250313'
				  AND CK_FILENT = '0102' AND CK_FILVEN = '0102'
				  GROUP BY CK_NUM, CK_NUMPV, CJ_ZZIDWEB,  CJ_VEND1, CJ_EMISSAO, CK_CLIENTE, CK_LOJA
				  )

			-- Realizando o INNER JOIN entre as duas consultas
			SELECT 
				SD2.FILIAL, 
				SD2.D2_CLIENTE,
				SD2.D2_LOJA,
				SD2.NOME,
				SD2.NOME_REDUZ,
				SCK.CJ_ZZIDWEB,
				SCK.ORCAMENTO,
				SCK.VLR_ORC,
				SCK.DT_ORC,
				SD2.PEDIDO,
				SD2.DOCUMENTO,
				SD2.SERIE,
				SD2.VLR_FAT, 
				SD2.DT_FAT,
				SD2.CASHBACK,
				SD2.TIPO_PV,
				SCK.VENDEDOR
			FROM 
				DOC_SAIDAS SD2
			INNER JOIN 
				ORCAMENTO SCK
			ON 
				SD2.PEDIDO = SCK.PEDIDO 
				WHERE CASHBACK <> '0'
				AND TIPO_PV = 'DUPLICATA'
				--AND DT_ORC  >= '13/03/2025' 
				--AND DT_ORC <= '21/03/2025'
				--AND ORCAMENTO = '115158'
				--AND CJ_ZZIDWEB = '20423'
				--AND D2_CLIENTE = '000175'
				--AND DOCUMENTO = '000013592'
				--AND DT_FAT = '31/03/2025'
				  AND DOCUMENTO = '".$documento."'
				ORDER BY  D2_CLIENTE, D2_LOJA, DT_FAT
        ";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function get_produtos_totvs_by_totvs($codigo){
		$dbtotvs = $this->load->database('totvs',TRUE);


        $q_totvs = "select * from SB1010 where D_E_L_E_T_ <> '*'
					AND B1_TIPO in ('PA','OI')
					AND B1_COD like '%".$codigo."%'
        ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	function lista_cashback_cliente($cliente){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "
			-- Primeira consulta como subquery
WITH DOC_SAIDAS AS (
    SELECT  
        D2_FILIAL AS FILIAL, 
        D2_CLIENTE,
		A1_NOME AS NOME,
		A1_NREDUZ AS NOME_REDUZ, 
        D2_LOJA, 
        SUM(D2_TOTAL) AS VLR_FAT, 
		SUM(D2_TOTAL * D2_ZZCHBCK / 100.0) AS CASHBACK,
        D2_PEDIDO AS PEDIDO, 
        D2_DOC AS DOCUMENTO,  
		D2_SERIE AS SERIE,
		CONVERT(VARCHAR,CONVERT(DATE,D2_EMISSAO),103) AS DT_FAT, IIF(F4_DUPLIC = 'S', 'DUPLICATA','BONIFICACAO') AS TIPO_PV
    FROM SD2010 SD2  WITH (NOLOCK)
	INNER JOIN SA1010 SA1 WITH (NOLOCK) ON A1_COD = D2_CLIENTE AND A1_LOJA = D2_LOJA
	INNER JOIN SB1010 SB1 WITH (NOLOCK) ON B1_COD = D2_COD
	INNER JOIN SF4010 SF4 WITH (NOLOCK) ON F4_CODIGO = D2_TES AND F4_FILIAL = '01'
    WHERE SD2.D_E_L_E_T_ = ' '  AND SA1.D_E_L_E_T_ = ' ' AND SF4.D_E_L_E_T_ = ' ' AND SB1.D_E_L_E_T_ = ' '
    AND D2_FILIAL =  '0102'
    AND D2_EMISSAO >= '20250313'
    GROUP BY D2_FILIAL, D2_CLIENTE, D2_LOJA, D2_PEDIDO, D2_DOC, D2_EMISSAO, A1_NOME, A1_NREDUZ, F4_DUPLIC, D2_SERIE
),
-- Segunda consulta como subquery
ORCAMENTO AS (
    SELECT DISTINCT 
		CK_CLIENTE, 
		CK_LOJA,
        CK_NUM AS ORCAMENTO, 
        CK_NUMPV AS PEDIDO, 
		CONVERT(VARCHAR,CONVERT(DATE,CJ_EMISSAO),103) AS DT_ORC,
        CJ_ZZIDWEB,  
		CJ_VEND1 AS VENDEDOR,
		SUM(CK_VALOR) AS VLR_ORC
    FROM SCK010 SCK WITH (NOLOCK)
    INNER JOIN SCJ010 SCJ  WITH (NOLOCK)
        ON CJ_NUM = CK_NUM 
       AND CJ_CLIENTE = CK_CLIENTE 
       AND CJ_LOJA = CK_LOJA
    WHERE SCK.D_E_L_E_T_ = ' ' 
      AND SCJ.D_E_L_E_T_ = ' ' 
	  AND SCJ.CJ_ZZIDWEB >= '20000'
	  AND SCJ.CJ_ZZIDWEB <> ''
	-- AND CJ_EMISSAO >= '20250313'
	  AND CK_FILENT = '0102' AND CK_FILVEN = '0102'
	  GROUP BY CK_NUM, CK_NUMPV, CJ_ZZIDWEB,  CJ_VEND1, CJ_EMISSAO, CK_CLIENTE, CK_LOJA
	  )

-- Realizando o INNER JOIN entre as duas consultas
SELECT 
    SD2.FILIAL, 
    SD2.D2_CLIENTE,
	SD2.D2_LOJA,
	SD2.NOME,
	SD2.NOME_REDUZ,
	SCK.CJ_ZZIDWEB,
    SCK.ORCAMENTO,
	SCK.VLR_ORC,
	SCK.DT_ORC,
	SD2.PEDIDO,
	SD2.DOCUMENTO,
	SD2.SERIE,
    SD2.VLR_FAT, 
	SD2.DT_FAT,
    SD2.CASHBACK,
	SD2.TIPO_PV,
	SCK.VENDEDOR
FROM 
    DOC_SAIDAS SD2
INNER JOIN 
    ORCAMENTO SCK
ON 
    SD2.PEDIDO = SCK.PEDIDO 
	WHERE CASHBACK <> '0'
	AND TIPO_PV = 'DUPLICATA'
	--AND DT_ORC  >= '13/03/2025' 
	--AND DT_ORC <= '21/03/2025'
	--AND ORCAMENTO = '115158'
	--AND CJ_ZZIDWEB = '20423'
    --AND D2_CLIENTE = '000175'
	--AND DOCUMENTO = '000013592'
	--AND DT_FAT = '31/03/2025'
	AND D2_CLIENTE = '".$cliente."'
	ORDER BY   DT_FAT
        ";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function get_all_estoque_totvs(){
		$dbtotvs = $this->load->database('totvs',TRUE);


        $q_totvs = "
			SELECT COD, PRODUTO, SLD_DISPONIVEL, RESERVADO, SLD_TOTAL, FILIAL FROM (
			SELECT B2_FILIAL FILIAL, B2_COD COD, B1_DESC PRODUTO, SUM(B2_QATU - B2_RESERVA ) SLD_DISPONIVEL, SUM(B2_RESERVA) RESERVADO,  SUM(B2_QATU) SLD_TOTAL, B1_GRUPO GRUPO
			FROM  SB2010 SB2 (NOLOCK)
			INNER JOIN SB1010 SB1 ON B1_COD = B2_COD
			AND B1_TIPO IN ('PA','OI')
			AND B1_MSBLQL = '2'
			AND B2_FILIAL = '0102'
			WHERE SB2.D_E_L_E_T_ = ' ' AND SB1.D_E_L_E_T_ = ' '
			GROUP BY B2_FILIAL, B2_COD, B1_DESC, B1_GRUPO
			) AS TEMP
			ORDER BY COD
        ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	function get_produtos_totvs_by_grupo_linha_1($grupo){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "select B1_ZZLINH1, * from SB1010 SB1 where SB1.D_E_L_E_T_ = ''
					AND B1_ZZLINH1 = '".$grupo."'
		";
		
        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	function get_produtos_totvs_by_grupo_linha_2($grupo){

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "select B1_ZZLINH2, * from SB1010 SB1 where SB1.D_E_L_E_T_ = ''
					AND B1_ZZLINH2 = '".$grupo."'
		";
		
        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function get_grupos_totvs(){

        $dbtotvs = $this->load->database('totvs',TRUE); 

        $q_totvs = "select * from Z01010 where D_E_L_E_T_ <> '*' ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	
	
	
	
	function get_preco_totvs_by_produto_tabela($produto, $tabela){

        $dbtotvs = $this->load->database('totvs',TRUE); 

        $q_totvs = "select DA1_PRCVEN from DA1010 where D_E_L_E_T_ <> '*' and DA1_CODPRO = '".$produto."' and DA1_CODTAB = '".$tabela."' ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->row_array(); 

    }
	
	
	
	function get_tabelas_totvs(){

        $dbtotvs = $this->load->database('totvs',TRUE); 

        $q_totvs = "select * from DA0010 where D_E_L_E_T_ <> '*' ";


        $query = $dbtotvs->query($q_totvs); 
        
        
        return $query->result_array(); 

    }
	
	
	function get_cliente_totvs(){

        $dbtotvs = $this->load->database('totvs',TRUE); 

        $q_totvs = "select * from SA1010 where D_E_L_E_T_ <> '*' ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function get_cliente_totvs_by_codigo($codigo){

        $dbtotvs = $this->load->database('totvs',TRUE); 

        $q_totvs = "select * from SA1010 where D_E_L_E_T_ <> '*' and A1_COD like '%".$codigo."%' ";


        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	


    
    function get_produto($produto_id)
    {
		$dbportal = $this->load->database('portal',TRUE);
        return $dbportal->get_where('produto',array('produto_id'=>$produto_id))->row_array();
    }
	
	function get_produto_by_ref($ref)
    {
        $dbportal = $this->load->database('portal',TRUE);
		return $dbportal->get_where('produto',array('ref'=>$ref))->row_array();
    }
	
	function get_produto_by_categoria($cat)
    {
        $dbportal = $this->load->database('portal',TRUE);
		return $dbportal->get_where('produto',array('categoria_id'=>$cat))->result_array();
    }
	
	function get_produto_by_ref_portal($ref)
    {
		$dbportal = $this->load->database('portal',TRUE);
        return $dbportal->get_where('produto',array('ref'=>$ref))->row_array();
    }
    
    function get_produto_by_slug($slug)
    {
        return $this->db->get_where('produto',array('slug'=>$slug))->row_array();
    }
    
        
    /*
     * Get all produto
     */
    function get_all_produto()
    {
		$dbportal = $this->load->database('portal',TRUE); 
        $dbportal->order_by('produto_id', 'desc');
        return $dbportal->get('produto')->result_array();
    }
	
	function get_all_produto_by_ref($ref)
    {
		$dbportal = $this->load->database('portal',TRUE); 
        $dbportal->where('ref', $ref);
        return $dbportal->get_where('produto')->result_array();
    }
        
    /*
     * function to add new produto
     */
    function add_produto($params)
    {
        $this->db->insert('produto',$params);
        return $this->db->insert_id();
    }
	
	function add_produto_portal($params)
    {
        $dbportal = $this->load->database('portal',TRUE); 
		$dbportal->insert('produto',$params);
        return $dbportal->insert_id();
    }
	
	function add_produto_categoria_portal($params)
    {
        $dbportal = $this->load->database('portal',TRUE); 
		$dbportal->insert('produto_categoria',$params);
        return $dbportal->insert_id();
    }
	
	
    
    /*
     * function to update produto
     */
    function update_produto($produto_id,$params)
    {
        $this->db->where('produto_id',$produto_id);
        return $this->db->update('produto',$params);
    }
    
	
	function update_produto_portal($produto_id,$params)
    {
		$dbportal = $this->load->database('portal',TRUE); 
        $dbportal->where('produto_id',$produto_id);
        return $dbportal->update('produto',$params);
    }
	
    /*
     * function to delete produto
     */
    function delete_produto($produto_id)
    {
        return $this->db->delete('produto',array('produto_id'=>$produto_id));
    }
}
