<?php

 
class Pedido_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    
    function get_pedido($pedido_id)
    {
        $this->db->select(' * ');
        $this->db->join('cliente', 'cliente.cliente_id = pedido.cliente_id', 'left');
        return $this->db->get_where('pedido',array('pedido_id'=>$pedido_id))->row_array();
    }
        
    
    function get_all_pedido()
    {
    	$this->db->select(' *');
    	$this->db->join('cliente', 'cliente.cliente_id = pedido.cliente_id', 'left');
        $this->db->order_by('pedido_id', 'desc');
        return $this->db->get('pedido')->result_array();
    }
	
	
	
	
	function get_all_pedidos_nulos()
    {
    	$dbportal = $this->load->database('portal',TRUE);
        $dbportal->where('codigo', NULL);
		$dbportal->or_where('codigo', "");
        return $dbportal->get('pedido')->result_array();
    }
	
	
	
	function get_all_pedidos()
    {
    	
		$dbportal = $this->load->database('portal',TRUE);
		$dbportal->select('*, cliente.codigo as cliente_codigo, pedido.codigo as pedido_codigo, tabela.codigo as tabela_codigo');
		$dbportal->join('cliente', 'cliente.cliente_id = pedido.cliente_id', 'left');
		$dbportal->join('tabela', 'cliente.tabela = tabela.tabela_id', 'left');
        $dbportal->order_by('pedido_id', 'desc');
		$dbportal->where("pedido.codigo IS NULL OR pedido.codigo = ''");
		$dbportal->where("pedido.qtd > 0");
		
		
		$dbportal->where("pedido.orcamento", 0); 
        return $dbportal->get('pedido')->result_array();
		
		
		/*
		$this->db->select('*, cliente.codigo as cliente_codigo, pedido.codigo as pedido_codigo, tabela.codigo as tabela_codigo');
		$this->db->join('cliente', 'cliente.cliente_id = pedido.cliente_id', 'left');
		$this->db->join('tabela', 'cliente.tabela = tabela.tabela_id', 'left');
        $this->db->order_by('pedido_id', 'desc');
		$this->db->where("pedido.codigo IS NULL OR pedido.codigo = ''");
        return $this->db->get('pedido')->result_array();
		*/
		
    }
	
	function get_all_pedidos_individual($pedido_id){
		$dbportal = $this->load->database('portal',TRUE);
		$dbportal->select('*, cliente.codigo as cliente_codigo, pedido.codigo as pedido_codigo, tabela.codigo as tabela_codigo');
		$dbportal->join('cliente', 'cliente.cliente_id = pedido.cliente_id', 'left');
		$dbportal->join('tabela', 'cliente.tabela = tabela.tabela_id', 'left');
        $dbportal->order_by('pedido_id', 'desc');
		$dbportal->where("pedido_id", $pedido_id);
		$dbportal->where("pedido.qtd > 0");
        return $dbportal->get('pedido')->result_array();
		
	}
    
    function get_total_dia($data){
    	$this->db->select('sum(total) as total');
    	$this->db->where("data > '".$data." 00:00:00'");
    	$this->db->where("data < '".$data." 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
    function get_total_mes($data){
    	$this->db->select('sum(total) as total');
    	$this->db->where("data > '".$data."-01 00:00:00'");
    	$this->db->where("data < '".$data."-31 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
    function get_total_ano($data){
    	$this->db->select('sum(total) as total');
	$this->db->where("data > '".$data."-01-01 00:00:00'");
    	$this->db->where("data < '".$data."-12-31 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
    function get_qtd_dia($data){
    	$this->db->select('count(qtd) as total');
    	$this->db->where("data > '".$data." 00:00:00'");
    	$this->db->where("data < '".$data." 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
    function get_qtd_mes($data){
    	$this->db->select('count(qtd) as total');
    	$this->db->where("data > '".$data."-01 00:00:00'");
    	$this->db->where("data < '".$data."-31 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
    function get_qtd_ano($data){
    	$this->db->select('count(qtd) as total');
	$this->db->where("data > '".$data."-01-01 00:00:00'");
    	$this->db->where("data < '".$data."-12-31 23:59:59'");
        return $this->db->get('pedido')->row_array();
    }
    
        
    /*
     * function to add new pedido
     */
    function add_pedido($params)
    {
        $this->db->insert('pedido',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update pedido
     */
  
	
	
	function update_pedido($pedido_id,$params)
    {
        
		$dbportal = $this->load->database('portal',TRUE);
		$dbportal->where('pedido_id',$pedido_id);
        return $dbportal->update('pedido',$params);
		
		
		/*
		$this->db->where('pedido_id',$pedido_id);
        return $this->db->update('pedido',$params);
		*/
    }
	
    
    /*
     * function to delete pedido
     */
    function delete_pedido($pedido_id)
    {
        return $this->db->delete('pedido',array('pedido_id'=>$pedido_id));
    }
}
