<?php

 
class Email_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
   
    /*
     * Get all email
     */
    function get_all_emails()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('emails')->result_array();
    }
    
    function get_all_emails_limit($limit)
    {
        $this->db->limit($limit);
        return $this->db->get('emails')->result_array();
    }
    
    function get_total_emails()
    {
        $this->db->select('count(id) as total');
        return $this->db->get('emails')->row_array();
    }
    
        
    /*
     * function to add new email
     */
    function add_email($params)
    {
        $this->db->insert('email',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update email
     */
    function update_email($email_id,$params)
    {
        $this->db->where('email_id',$email_id);
        return $this->db->update('email',$params);
    }
    
    /*
     * function to delete email
     */
    function delete_email($email_id)
    {
        return $this->db->delete('email',array('email_id'=>$email_id));
    }
}
