<?php
 
class Distribuidor_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
	
	function get_distribuidor_portal_by_codigo($codigo){
		$dbportal = $this->load->database('portalhobety',TRUE);
		$dbportal->select('*');	
		$dbportal->where("codigo", $codigo); 
        return $dbportal->get('distribuidor')->row_array();
	}
		
    
    function get_distribuidores_totvs(){
		
		

        $dbtotvs = $this->load->database('totvs',TRUE); 
		
		$q_totvs = "
		SELECT
    u.D2_CLIENTE AS COD, 
    u.A1_NOME AS NOME, A1_NREDUZ NOME_REDUZIDO,
 A1_CGC CNPJCPF, A1_PESSOA TIPO,A1_EST UF, A1_DDD DDD, A1_TEL TELEFONE,     u.A1_MUN AS MUNICIPIO, 
 A1_END ENDERECO, A1_BAIRRO BAIRRO, A1_CEP CEP,
VLR_FATDESC, VLR_FATBRU, MEDIA_VLR_BRUTO, QTD_ITEM, DT_PRICOM, DT_ULCOMP, 

    SUM(SD2_1.D2_QUANT * SD2_1.D2_PRUNIT) AS VLR_PRD_BRUTO, 
    u.A1_ZZVLBN5 AS VBN_5, 
    u.A1_ZZVLBN8 AS VBN_8,

    CASE
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 1, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0) THEN 'F0'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 2, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 1, 0) THEN 'F1'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 3, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 2, 0) THEN 'F2'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 4, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 3, 0) THEN 'F3'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 5, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 4, 0) THEN 'F4'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 6, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 5, 0) THEN 'F5'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 7, 0) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - 6, 0) THEN 'CESSADO'
        WHEN MAX(u.ULT_PEDIDO) >= DATEADD(MONTH, -12, DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)) AND MAX(u.ULT_PEDIDO) < DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0) THEN 'INATIVO'
        WHEN MAX(u.ULT_PEDIDO) = u.A1_PRICOM THEN 'INICIADO'
        ELSE 'F0'
    END AS ATIVIDADE,A1_VEND VENDEDOR

   
FROM (
    SELECT
        SD2.D2_CLIENTE,  
        MAX(SD2.D2_EMISSAO) AS ULT_PEDIDO, 
        SA1.A1_NOME, 
        SA1.A1_MUN, 
        SA1.A1_EST, 
        SA1.A1_VEND, 
        SA1.A1_PRICOM, 
        SA1.A1_ZZVLBN5, 
        SA1.A1_ZZVLBN8, 
        SA1.A1_ZZQTCID, A1_NREDUZ, A1_CGC, A1_PESSOA, A1_DDD, A1_TEL, A1_END, A1_BAIRRO, A1_CEP,
		 SUM(SD2.D2_TOTAL) AS VLR_FATDESC, SUM(SD2.D2_QUANT * SD2.D2_PRUNIT) AS VLR_FATBRU, ((SUM(SD2.D2_QUANT * SD2.D2_PRUNIT)) / 12 ) AS MEDIA_VLR_BRUTO,
 SUM(D2_QUANT) QTD_ITEM,  MIN(CONVERT(VARCHAR,CONVERT(DATE,A1_PRICOM),103)) DT_PRICOM, RIGHT('00' + CAST(DAY(MAX(D2_EMISSAO)) AS VARCHAR), 2) + '/' +
RIGHT('00' + CAST(MONTH(MAX(D2_EMISSAO)) AS VARCHAR), 2) + '/' +
CAST(YEAR(MAX(D2_EMISSAO)) AS VARCHAR) AS DT_ULCOMP
    FROM SD2010 AS SD2 
    INNER JOIN SB1010 AS SB1 ON SB1.B1_COD = SD2.D2_COD
    INNER JOIN SF4010 AS SF4 ON SF4.F4_CODIGO = SD2.D2_TES
    INNER JOIN SF2010 AS SF2 ON SF2.F2_DOC = SD2.D2_DOC AND SF2.F2_SERIE = SD2.D2_SERIE AND SF2.F2_FILIAL = SD2.D2_FILIAL 
    INNER JOIN SA1010 AS SA1 ON SA1.A1_COD = SD2.D2_CLIENTE AND SA1.A1_LOJA = '01'
    WHERE 
        SD2.D_E_L_E_T_ = ' ' AND 
        SB1.D_E_L_E_T_ = ' ' AND 
        SF4.D_E_L_E_T_ = ' ' AND 
        SF2.D_E_L_E_T_ = '' AND 
        SA1.D_E_L_E_T_ = '' AND 
        SD2.D2_FILIAL IN ( '0102','0103') AND 
        SF4.F4_DUPLIC = 'S' AND 
        SF2.F2_VEND1 IN  ('000004','000003','000006','000009','000015') AND 
        SD2.D2_EMISSAO BETWEEN CONVERT(date, DATEADD(MONTH, -12, CURRENT_TIMESTAMP), 103) AND CONVERT(date, CURRENT_TIMESTAMP, 103)
    GROUP BY 
        SD2.D2_CLIENTE, 
        SA1.A1_NOME, 
        SA1.A1_MUN, 
        SA1.A1_EST, 
        SA1.A1_VEND, 
        SA1.A1_PRICOM, 
        SA1.A1_ZZVLBN5, 
        SA1.A1_ZZVLBN8, 
        SA1.A1_ZZQTCID, A1_NREDUZ, A1_CGC, A1_PESSOA, A1_DDD, A1_TEL, A1_END, A1_BAIRRO, A1_CEP

) u
JOIN SD2010 AS SD2_1 ON SD2_1.D2_CLIENTE = u.D2_CLIENTE 
    AND DATEPART(year, SD2_1.D2_EMISSAO) = DATEPART(year, u.ULT_PEDIDO)
    AND DATEPART(month, SD2_1.D2_EMISSAO) = DATEPART(month, u.ULT_PEDIDO)
INNER JOIN SF4010 AS SF4 ON SF4.F4_CODIGO = SD2_1.D2_TES 
    AND SF4.D_E_L_E_T_ = ' ' 
    AND SF4.F4_DUPLIC = 'S' 
    AND SD2_1.D2_FILIAL = '0102'
	
GROUP BY
    u.D2_CLIENTE, 
    u.ULT_PEDIDO, 
    u.A1_NOME,  
    u.A1_MUN, 
    u.A1_EST, 
    u.A1_VEND, 
    u.A1_PRICOM, 
    u.A1_ZZVLBN5, 
    u.A1_ZZVLBN8, 
    u.A1_ZZQTCID,
	u.A1_NREDUZ, u.A1_CGC, u.A1_PESSOA, u.A1_DDD, u.A1_TEL, u.A1_END, u.A1_BAIRRO, u.A1_CEP, u.VLR_FATDESC, u.VLR_FATBRU, u.MEDIA_VLR_BRUTO,u.QTD_ITEM, u.DT_PRICOM, u.DT_ULCOMP,
    DATEPART(year, SD2_1.D2_EMISSAO),
    DATEPART(month, SD2_1.D2_EMISSAO)

	
ORDER BY COD;

        ";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

    }
	
	
	function update_distribuidor_portal($distribuidor_id,$params)
    {
        
		$dbportal = $this->load->database('portalhobety',TRUE);
		$dbportal->where('distribuidor_id',$distribuidor_id);
        return $dbportal->update('distribuidor',$params);
		
		
    }
	
	function add_distribuidor_portal($params)
    {
		$dbportal = $this->load->database('portalhobety',TRUE);
        $dbportal->insert('distribuidor',$params);
        return $dbportal->insert_id();
    }
	
	
}
