<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */
 
class Cliente_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get cliente by cliente_id
     */
    function get_cliente($cliente_id)
    {
        return $this->db->get_where('cliente',array('cliente_id'=>$cliente_id))->row_array();
    }
	
	
	function get_cliente_by_cgc($cgc)
    {
	    
		$dbportal = $this->load->database('portal',TRUE);
        return $dbportal->get_where('cliente',array('cpf'=>$cgc))->row_array();
		/*
		return $this->db->get_where('cliente',array('cpf'=>$cgc))->row_array();
		*/
    }
	
	public function get_all_clientes_indexed_by_codigo_loja()
	{
		$dbportal = $this->load->database('portal',TRUE);
		$dbportal->select('*');
		$dbportal->from('cliente');
		$query = $dbportal->get();

		$clientes_indexados = array();
		foreach ($query->result_array() as $row) {
			// Ajuste os campos de acordo com os nomes corretos na tabela (exemplo: 'codigo', 'loja')
			$codigo = $row['codigo'];
			$loja   = $row['loja'];

			// Indexa por [codigo][loja]
			$clientes_indexados[$codigo][$loja] = $row;
		}
		return $clientes_indexados;
	}

	
	
	
	
	
	
	function get_all_distribuidores_totvs(){
		$dbtotvs = $this->load->database('totvs',TRUE); 
		
		/*
		$q_totvs = "SELECT * FROM SA1010 SA1 WHERE SA1.D_E_L_E_T_ = ' '
					AND A1_LOJA = '01'
					AND A1_GRPVEN = '000001'
					ORDER BY A1_COD
        ";
		*/
		
		$q_totvs = "
			SELECT * FROM SA1010 SA1 
			WHERE SA1.D_E_L_E_T_ = ' '
			AND A1_GRPVEN = '000005'
			ORDER BY A1_COD
		";

        $query = $dbtotvs->query($q_totvs); //para selecionar registros
        
        
        return $query->result_array(); 

	}
	
	function get_cliente_by_codigo($codigo)
    {
	    
		$dbportal = $this->load->database('portal',TRUE);
        return $dbportal->get_where('cliente',array('codigo'=>$codigo))->result_array();
		
		
		/*
		return $this->db->get_where('cliente',array('cpf'=>$cgc))->row_array();
		*/
    }
	
        
    /*
     * Get all cliente
     */
    function get_all_clientes()
    {
        $this->db->order_by('cliente_id', 'desc');
        return $this->db->get('cliente')->result_array();
    }
        
    /*
     * function to add new cliente
     */
    function add_cliente($params)
    {
		
		$dbportal = $this->load->database('portal',TRUE);
        $dbportal->insert('cliente',$params);
        return $dbportal->insert_id();
		
		/*
		$this->db->insert('cliente',$params);
        return $this->db->insert_id();
		*/
    }
	
	
	function add_distribuidor($params)
    {
		
		$dbportal = $this->load->database('portal',TRUE);
        $dbportal->insert('distribuidor_site',$params);
        return $dbportal->insert_id();
		
		
    }
    
    /*
     * function to update cliente
     */
    function update_cliente($cliente_id,$params)
    {
		
		$dbportal = $this->load->database('portal',TRUE);
        $dbportal->where('cliente_id',$cliente_id);
        return $dbportal->update('cliente',$params);
		
		/*
		$this->db->where('cliente_id',$cliente_id);
        return $this->db->update('cliente',$params);
		*/
    }
	
	function atualiza_cashback_portal_by_pedido($pedido_id,$params)
    {
		
		$dbportal = $this->load->database('portal',TRUE);
        $dbportal->where('pedido_id',$pedido_id);
        return $dbportal->update('cliente_cashback',$params);  
		
    }
    
    /*
     * function to delete cliente
     */
    function delete_cliente($cliente_id)
    {
        return $this->db->delete('cliente',array('cliente_id'=>$cliente_id));
    }
	
	
	function delete_cashbacks_nao_atualizados()
    {
		$dbportal = $this->load->database('portal',TRUE);
        return $dbportal->delete('cliente_cashback',array('atualizado' => 0));
    }
	
}
