<?php

class Banner_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get banner by banner_id
     */
    function get_banner($banner_id)
    {
        return $this->db->get_where('banner',array('banner_id'=>$banner_id))->row_array();
    }
        
    /*
     * Get all banner
     */
    function get_all_banner()
    {
        $this->db->order_by('banner_id', 'desc');
        return $this->db->get('banner')->result_array();
    }
        
    /*
     * function to add new banner
     */
    function add_banner($params)
    {
        $this->db->insert('banner',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update banner
     */
    function update_banner($banner_id,$params)
    {
        $this->db->where('banner_id',$banner_id);
        return $this->db->update('banner',$params);
    }
    
    /*
     * function to delete banner
     */
    function delete_banner($banner_id)
    {
        return $this->db->delete('banner',array('banner_id'=>$banner_id));
    }
}
