<?php

 
class Tamanho extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Tamanho_model');
    } 

    /*
     * Listing of tamanho
     */
    function index()
    {
    	$data['config'] = $this->Config_model->get_config();
    	
        $data['tamanho'] = $this->Tamanho_model->get_all_tamanhos();
        
        $data['_view'] = 'tamanho/index';
        $this->load->view('layouts/main',$data);
    }

    /*
     * Adding a new tamanho
     */
    function add()
    {   
    	$data['config'] = $this->Config_model->get_config();
    
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'descricao' => $this->input->post('descricao'),
            );
            
            $tamanho_id = $this->Tamanho_model->add_tamanho($params);
            redirect('tamanho/index');
        }
        else
        {            
            $data['_view'] = 'tamanho/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a tamanho
     */
    function edit($tamanho_id)
    {   
    	$data['config'] = $this->Config_model->get_config();
    
        // check if the tamanho exists before trying to edit it
        $data['tamanho'] = $this->Tamanho_model->get_tamanho($tamanho_id);
        
        if(isset($data['tamanho']['tamanho_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'descricao' => $this->input->post('descricao'),
                );

                $this->Tamanho_model->update_tamanho($tamanho_id,$params);            
                redirect('tamanho/index');
            }
            else
            {
                $data['_view'] = 'tamanho/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The tamanho you are trying to edit does not exist.');
    } 

    /*
     * Deleting tamanho
     */
    function remove($tamanho_id)
    {
        $tamanho = $this->Tamanho_model->get_tamanho($tamanho_id);

        // check if the tamanho exists before trying to delete it
        if(isset($tamanho['tamanho_id']))
        {
            $this->Tamanho_model->delete_tamanho($tamanho_id);
            redirect('tamanho/index');
        }
        else
            show_error('The tamanho you are trying to delete does not exist.');
    }
    
}
