<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */
 
class Sku extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Sku_model');
    } 

    /*
     * Listing of sku
     */
    function index()
    {
        $data['sku'] = $this->Sku_model->get_all_sku();
        
        $data['_view'] = 'sku/index';
        $this->load->view('layouts/main',$data);
    }

    /*
     * Adding a new sku
     */
    function add()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'produto_id' => $this->input->post('produto_id'),
				'cor_id' => $this->input->post('cor_id'),
				'tamanho_id' => $this->input->post('tamanho_id'),
				'preco' => $this->input->post('preco'),
				'saldo' => $this->input->post('saldo'),
				'status' => $this->input->post('status'),
            );
            
            $sku_id = $this->Sku_model->add_sku($params);
            redirect('sku/index');
        }
        else
        {
			$this->load->model('Produto_model');
			$data['all_produto'] = $this->Produto_model->get_all_produto();

			$this->load->model('Cor_model');
			$data['all_cor'] = $this->Cor_model->get_all_cor();

			$this->load->model('Tamanho_model');
			$data['all_tamanho'] = $this->Tamanho_model->get_all_tamanho();
            
            $data['_view'] = 'sku/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a sku
     */
    function edit($sku_id)
    {   
        // check if the sku exists before trying to edit it
        $data['sku'] = $this->Sku_model->get_sku($sku_id);
        
        if(isset($data['sku']['sku_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'produto_id' => $this->input->post('produto_id'),
					'cor_id' => $this->input->post('cor_id'),
					'tamanho_id' => $this->input->post('tamanho_id'),
					'preco' => $this->input->post('preco'),
					'saldo' => $this->input->post('saldo'),
					'status' => $this->input->post('status'),
                );

                $this->Sku_model->update_sku($sku_id,$params);            
                redirect('sku/index');
            }
            else
            {
				$this->load->model('Produto_model');
				$data['all_produto'] = $this->Produto_model->get_all_produto();

				$this->load->model('Cor_model');
				$data['all_cor'] = $this->Cor_model->get_all_cor();

				$this->load->model('Tamanho_model');
				$data['all_tamanho'] = $this->Tamanho_model->get_all_tamanho();

                $data['_view'] = 'sku/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The sku you are trying to edit does not exist.');
    } 

    /*
     * Deleting sku
     */
    function remove($sku_id)
    {
        $sku = $this->Sku_model->get_sku($sku_id);

        // check if the sku exists before trying to delete it
        if(isset($sku['sku_id']))
        {
            $this->Sku_model->delete_sku($sku_id);
            redirect('sku/index');
        }
        else
            show_error('The sku you are trying to delete does not exist.');
    }
    
}
