<?php

 
class Produto extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Produto_model');
		$this->load->model('Categoria_model');
        $this->load->model('Imagem_produto_model');
		$this->load->model('Preco_model');
    } 

    /*
     * Listing of produto
     */
    function index()
    {
        $data['produto'] = $this->Produto_model->get_all_produto();
        $data['config'] = $this->Config_model->get_config();
        
        $data['_view'] = 'produto/index';
        $this->load->view('layouts/main',$data);
    }
	
	function teste3(){
		ini_set('display_erros', 1);
		ini_set('display_startup_errors', 1);
		error_reporting(E_ALL);
		var_dump($this->load->database('totvs', TRUE));
	}

    function atualiza_categoria(){
    	

		function createSlug($str, $delimiter = '-'){

			$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
			return $slug;
		
		} 
	
	
		$grupos_totvs = $this->Produto_model->get_grupos_totvs();

    	foreach($grupos_totvs as $prod){
			
			
			$check = $this->Categoria_model->get_categoria_by_codigo_portal($prod['Z01_COD']);
			
			
			if(!$check){
			
				
				
				$slug = createSlug($prod['Z01_DESC']);
				
				$params = array(
					'codigo' => $prod['Z01_COD'],
					'nome' => $prod['Z01_DESC'],
					'slug' => $slug,
					
				);
				
				$produto_id = $this->Categoria_model->add_categoria_portal($params);
				
				echo "Inseriu a categoria: ".$prod['Z01_COD']." - ".$prod['Z01_DESC']."<br />";
				
			} else {
				
				
				
				
				$slug = createSlug($prod['Z01_DESC']);
				
				$params = array(
					'codigo' => $prod['Z01_COD'],
					'nome' => $prod['Z01_DESC'],
					'slug' => $slug,
					
				);
				
				$produto_id = $this->Categoria_model->update_categoria_portal($check['categoria_id'],$params);
				
				echo "Atualizou a categoria: ".$prod['Z01_COD']." - ".$prod['Z01_DESC']." - ".$slug.'-'. $check['categoria_id']."<br />";
				//print_r($check);
				//echo '<br>';
				
			}
    	}
		
    }
	
	
	
	function show_produtos(){
    	

	
		$this->load->model('Categoria_model');
		$produtos_totvs = $this->Produto_model->get_produtos_totvs();
		
		
		print_r($produtos_totvs);
		
		
    }
	
	
	
	
	function atualiza_portal_produto(){
    	

		function createSlug($str, $delimiter = '-'){

			$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
			return $slug;
		
		} 
	
		$this->load->model('Categoria_model');
		$produtos_totvs = $this->Produto_model->get_produtos_totvs();
		
		
    	foreach($produtos_totvs as $prod){
    		
			
			$check = $this->Produto_model->get_produto_by_ref_portal($prod['B1_COD']);
			
			if(!$check){
			
				$slug = createSlug($prod['B1_DESC']);		
				$categoria = $this->Categoria_model->get_categoria_by_codigo(trim($prod['B1_ZZLINH1']));
				$categoria2 = $this->Categoria_model->get_categoria_by_codigo(trim($prod['B1_ZZLINH2']));
				
			
				$params = array(
					'ref' => trim($prod['B1_COD']),
					'nome' => trim($prod['B1_DESC']),
					'slug' => $slug,
					'categoria_id' => $categoria['categoria_id'],
					'categoria_id2' => $categoria2['categoria_id'],
					'qtdlote' => $prod['B1_ZZQTWEB'],
				);
				
				$produto_id = $this->Produto_model->add_produto_portal($params);
				
				echo "Inseriu: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";
				
			
			} else{
				
				$slug = createSlug($prod['B1_DESC']);		
				$categoria = $this->Categoria_model->get_categoria_by_codigo(trim($prod['B1_ZZLINH1']));
				$categoria2 = $this->Categoria_model->get_categoria_by_codigo(trim($prod['B1_ZZLINH2']));
				
				
				
				$params = array(
					'ref' => trim($prod['B1_COD']),
					'nome' => trim($prod['B1_DESC']),
					'slug' => $slug,
					'categoria_id' => $categoria['categoria_id'],
					'categoria_id2' => $categoria2['categoria_id'],
					'qtdlote' => $prod['B1_ZZQTWEB'],
				);
				
				$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
				
				echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";


			}
			
			
    	}
		
		
		
    }
	
	
    function atualiza_produto(){
    	
		
		?>
			<h1 style="font-size:14px;">ATUALIZAR TODOS OS PRODUTOS</h1>
			<form action="" method="POST">
				<input type="hidden" name="atualizar" value="1" />
				<input type="submit" onclick="document.getElementById('loader').style.display = 'block'" value="ATUALIZAR">
			</form>
			<div id="loader" style="width: 100%; height: 100%; background-color: #dcdcdc; opacity: 50%; display: none;z-index: 99999; position: fixed; margin-top: -70px;"><h1 style="margin-left: 40%; margin-top: 20%;">Processando</h1><h2 style="margin-left: 40%;">Por favor, não feche a página.</h2></div>
		<?php
		
		
		
		if($this->input->post('atualizar')){
		
		
			

			function createSlug($str, $delimiter = '-'){

				$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
				return $slug;
			
			} 
			
			$this->load->model('Categoria_model');
			$produtos_totvs = $this->Produto_model->get_produtos_totvs();
			
			
			

			foreach($produtos_totvs as $prod){
				
				
				
				$check = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
				
				if($prod['B1_MSBLQL'] == '1' )
					$status = 0;
				else
					$status = 1;
				
				echo "status: ".$prod['B1_MSBLQL']."<br>";
				
				if(!$check){
				
					$slug = createSlug($prod['B1_DESC']);		
					$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
					$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
					
				
					$params = array(
						'ref' => trim($prod['B1_COD']),
						'nome' => trim($prod['B1_DESC']),
						'slug' => $slug,
						'qtdlote' => $prod['B1_ZZQTWEB'],
						'status' => $status,
						'cashback' => $prod['B1_ZZCSHBC'],
					);
					
					$produto_id = $this->Produto_model->add_produto_portal($params);
					
					if($categoria){
						$params = array(
							'produto_id' => $produto_id,
							'categoria_id' => $categoria['categoria_id']
						);
						$this->Produto_model->add_produto_categoria_portal($params); 
					}
					
					if($categoria2){
						$params = array(
							'produto_id' => $produto_id,
							'categoria_id' => $categoria2['categoria_id']
						);
						$this->Produto_model->add_produto_categoria_portal($params);
					}
					
					echo "Inseriu: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";
					
				
				} else{
					
					$slug = createSlug($prod['B1_DESC']);		
					$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
					$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
					
					
					
					$params = array(
						'ref' => trim($prod['B1_COD']),
						'nome' => trim($prod['B1_DESC']),
						'slug' => $slug,
						'qtdlote' => $prod['B1_ZZQTWEB'],
						'cashback' => $prod['B1_ZZCSHBC'],
						'status' => $status,
					);
					
					$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
					
					
					if($categoria){
						$params = array(
							'produto_id' => $check['produto_id'],
							'categoria_id' => $categoria['categoria_id']
						);
						$this->Produto_model->add_produto_categoria_portal($params); 
					}
					
					if($categoria2){
						$params = array(
							'produto_id' => $check['produto_id'],
							'categoria_id' => $categoria2['categoria_id']
						);
						$this->Produto_model->add_produto_categoria_portal($params);
					}
					
					echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";


				}
				
				
			}
		
			echo '<script>document.getElementById("loader").style.display = "none";</script>';
			echo '<script>alert("Todos os produtos foram atualizados com sucesso! \n" + "Já pode sair da página.");</script>';
		}
    }
	
	
	
	
	function atualiza_prod(){
    	
		?>
			<h1 style="font-size:14px;">ATUALIZAÇÃO DE PRODUTO INDIVIDUAL</h1>
			<form action="" method="GET">
				<input type="text" name="codigo_prod" placeholder="Codigo do Produto" />
				<input type="submit" onclick="document.getElementById('loader').style.display = 'block'" value="ATUALIZAR">
			</form>
			<div id="loader" style="width: 100%; height: 100%; background-color: #dcdcdc; opacity: 50%; display: none;z-index: 99999; position: fixed; margin-top: -70px;"><h1 style="margin-left: 40%; margin-top: 20%;">Processando</h1><h2 style="margin-left: 40%;">Por favor, não feche a página.</h2></div>
		<?php
		
		
		if($this->input->get('codigo_prod')){
			
		
			
			
			function createSlug($str, $delimiter = '-'){

				$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
				return $slug;
			
			} 
		
			$this->load->model('Categoria_model');
			$produtos_totvs = $this->Produto_model->get_produtos_totvs_by_totvs($this->input->get('codigo_prod'));
			
			
			

			foreach($produtos_totvs as $prod){
				
				
				$check = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
				
				
				if($prod['B1_MSBLQL'] == '1' )
					$status = 0;
				else
					$status = 1;
				
				if(!$check){
				
					$slug = createSlug($prod['B1_DESC']);		
					$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
					$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
					
				
					$params = array(
						'ref' => trim($prod['B1_COD']),
						'nome' => trim($prod['B1_DESC']),
						'slug' => $slug,
						'categoria_id' => $categoria['categoria_id'],
						'categoria_id2' => $categoria2['categoria_id'],
						'qtdlote' => $prod['B1_ZZQTWEB'],
						'status' => $status,
					);
					
					$produto_id = $this->Produto_model->add_produto_portal($params);
					
					echo "Inseriu: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";
					
				
				} else{
					
					$slug = createSlug($prod['B1_DESC']);		
					$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
					$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
					
					
					
					$params = array(
						'ref' => trim($prod['B1_COD']),
						'nome' => trim($prod['B1_DESC']),
						'slug' => $slug,
						'categoria_id' => $categoria['categoria_id'],
						'categoria_id2' => $categoria2['categoria_id'],
						'qtdlote' => $prod['B1_ZZQTWEB'],
						'status' => $status,
					);
					
					$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
					
					echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."<br />";


				}
				
				$this->load->model('Tabela_model');
				$tabelas = $this->Tabela_model->get_all_tabelas();
				
				
				foreach($tabelas as $tabela){
				
					$pro = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
				
					$check = $this->Preco_model->get_preco_by_produto_tabela($pro['produto_id'], $tabela['tabela_id']);
					
			
					$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
					
					$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($pro['ref'], $tab['codigo']);
					 
					
					if($preco['DA1_PRCVEN'])
						$prc = $preco['DA1_PRCVEN'];
					else
						$prc = 0;
						
					if(!$check){
						
						
						
						$params = array(
							'produto_id' => $pro['produto_id'],
							'tabela_id' => $tabela['tabela_id'],
							'preco' => $prc,
						);
						$this->Preco_model->add_preco($params);
						
						echo "Inseriu o preco<br />";
						
					
					} else{
						
						
						
						$params = array(
							'produto_id' => $pro['produto_id'],
							'tabela_id' => $tabela['tabela_id'], 
							'preco' => $prc,
						);
						
						$this->Preco_model->update_preco($check['preco_id'], $params);
						
						echo "Atualizou o preço para ".$prc." na tabela ".$tab['codigo']."<br />";


					}
					
				}
			}
			
			echo '<script>document.getElementById("loader").style.display = "none";</script>';
			echo '<script>alert("Produto Atualizado com sucesso! \n" + "Já pode sair da página.");</script>';
			
		}
			
		
    }
	
	function teste2(){
		/*
		$produtos = $this->Produto_model->get_produtos_totvs_by_grupo_linha_1('004');
		echo 'grupo 1: <pre>';
		//print_r($produtos_totvs);
		foreach($produtos as $prod){
			echo $prod['B1_COD'].' - 1: '.$prod['B1_ZZLINH1'].' - 2: '.$prod['B1_ZZLINH2'].'<br>';
		}
		
		$produtos = $this->Produto_model->get_produtos_totvs_by_grupo_linha_2('004');
		echo 'grupo 2: <pre>';
		//print_r($produtos_totvs);
		foreach($produtos as $prod){
			echo $prod['B1_COD'].' - 1: '.$prod['B1_ZZLINH1'].' - 2: '.$prod['B1_ZZLINH2'].'<br>';
		}
		*/
		$this->load->model('Categoria_model');
		$produtos_totvs = $this->Produto_model->get_produtos_totvs_by_grupo_linha_1('004');
		
		//print_r($produtos_totvs);
		
		//echo $this->input->get('grupo1');
		
		foreach($produtos_totvs as $prod){
			
			
			$check = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
			
			
			if($prod['B1_MSBLQL'] == '1' )
				$status = 0;
			else
				$status = 1;
			
			if($check){
						
			
			
			$params = array(
				'status' => $status,
			);
			
			$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
			
			echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."status: ".$status."<br />";


		}
		}
	}
	
	function atualiza_prod_by_grupo(){
    	$grupos = $this->Produto_model->get_grupos_totvs();
		?>
			<h1 style="font-size:14px;">ATUALIZAÇÃO DE PRODUTO POR GRUPO</h1>
			<form action="" method="GET">
				<select name="grupo1" >
					<option value="">Grupo linha 1</option>
					<?php 
						foreach($grupos as $g){
							echo '<option value="'.$g['Z01_COD'].'">'.$g['Z01_DESC'].'</option>';
						}
					?>
				</select><br>
				
				<select name="grupo2" >
					<option value="">Grupo linha 2</option>
					<?php 
						foreach($grupos as $g){
							echo '<option value="'.$g['Z01_COD'].'">'.$g['Z01_DESC'].'</option>';
						}
					?>
				</select><br>
				<input type="submit" onclick="document.getElementById('loader').style.display = 'block'" value="ATUALIZAR">
			</form>
			<div id="loader" style="width: 100%; height: 100%; background-color: #dcdcdc; opacity: 50%; display: none;z-index: 99999; position: fixed; margin-top: -110px; margin-left:-8px;"><h1 style="margin-left: 40%; margin-top: 20%;">Processando</h1><h2 style="margin-left: 40%;">Por favor, não feche a página.</h2></div>
		<?php
		
		
		
		
		if($this->input->get()){
			
			function createSlug($str, $delimiter = '-'){

					$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
					return $slug;
				
				} 
			
			if($this->input->get('grupo1') and $this->input->get('grupo1') != ""){
			
				$categoria = $this->Categoria_model->get_categoria_by_codigo($this->input->get('grupo1'));
				$produtos_portal = $this->Produto_model->get_produto_by_categoria($categoria['categoria_id']);
				
				foreach($produtos_portal as $prod_port){
					$params = array(
						'status' => '0'
					);
					$this->Produto_model->update_produto_portal($prod_port['produto_id'], $params);
				}
			
				$this->load->model('Categoria_model');
				$produtos_totvs = $this->Produto_model->get_produtos_totvs_by_grupo_linha_1($this->input->get('grupo1'));
				
				//print_r($produtos_totvs);
				
				//echo $this->input->get('grupo1');
				
				foreach($produtos_totvs as $prod){
					
					
					$check = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
					
					
					if($prod['B1_MSBLQL'] == '1' )
						$status = 0;
					else
						$status = 1;
					
					if(!$check){
					
						$slug = createSlug($prod['B1_DESC']);		
						$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
						$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
						
					
						$params = array(
							'ref' => trim($prod['B1_COD']),
							'nome' => trim($prod['B1_DESC']),
							'slug' => $slug,
							'categoria_id' => $categoria['categoria_id'],
							'categoria_id2' => $categoria2['categoria_id'],
							'qtdlote' => $prod['B1_ZZQTWEB'],
							'status' => $status,
						);
						
						$produto_id = $this->Produto_model->add_produto_portal($params);
						
						echo "Inseriu: ".$produto_id. " - " .$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."status: ".$status."<br />";
						
					
					} else{
						
						$slug = createSlug($prod['B1_DESC']);		
						$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
						$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
						
						
						
						$params = array(
							'ref' => trim($prod['B1_COD']),
							'nome' => trim($prod['B1_DESC']),
							'slug' => $slug,
							'categoria_id' => $categoria['categoria_id'],
							'categoria_id2' => $categoria2['categoria_id'],
							'qtdlote' => $prod['B1_ZZQTWEB'],
							'status' => $status,
						);
						
						$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
						
						echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."status: ".$status."<br />";


					}
					
					$this->load->model('Tabela_model');
					$tabelas = $this->Tabela_model->get_all_tabelas();
					
					foreach($tabelas as $tabela){
					
						$pro = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
					
						$check = $this->Preco_model->get_preco_by_produto_tabela($pro['produto_id'], $tabela['tabela_id']);
						
				
						$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
						
						$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($pro['ref'], $tab['codigo']);
						
						if($preco['DA1_PRCVEN'])
							$prc = $preco['DA1_PRCVEN'];
						else
							$prc = 0;
							
						if(!$check){
							
							
							
							$params = array(
								'produto_id' => $pro['produto_id'],
								'tabela_id' => $tabela['tabela_id'],
								'preco' => $prc,
							);
							$this->Preco_model->add_preco($params);
							
							echo "Inseriu o preco<br />";
							
						
						} else{
							
							
							
							$params = array(
								'produto_id' => $pro['produto_id'],
								'tabela_id' => $tabela['tabela_id'],
								'preco' => $prc,
							);
							
							$this->Preco_model->update_preco($check['preco_id'], $params);
							
							echo "Atualizou o preço<br />";


						}
						
					}
				}
				
			}
			
			if( $this->input->get('grupo2') != ""){
				
			
				$this->load->model('Categoria_model');
				$produtos_totvs = $this->Produto_model->get_produtos_totvs_by_grupo_linha_2($this->input->get('grupo2'));
				
				
				$categoria = $this->Categoria_model->get_categoria_by_codigo($this->input->get('grupo2'));
				$produtos_portal = $this->Produto_model->get_produto_by_categoria($categoria['categoria_id']);
				
				foreach($produtos_portal as $prod_port){
					$params = array(
						'status' => 0
					);
					$this->Produto_model->update_produto_portal($prod_port['produto_id'], $params);
				}
				
				
				
				
				foreach($produtos_totvs as $prod){
					
					
					$check = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
					
					
					if($prod['B1_MSBLQL'] == '1' )
						$status = 0;
					else
						$status = 1;
					
					if(!$check){
					
						$slug = createSlug($prod['B1_DESC']);		
						$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
						$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
						
					
						$params = array(
							'ref' => trim($prod['B1_COD']),
							'nome' => trim($prod['B1_DESC']),
							'slug' => $slug,
							'categoria_id' => $categoria['categoria_id'],
							'categoria_id2' => $categoria2['categoria_id'],
							'qtdlote' => $prod['B1_ZZQTWEB'],
							'status' => $status,
						);
						
						$produto_id = $this->Produto_model->add_produto_portal($params);
						
						echo "Inseriu: ".$produto_id. " - " .$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."status: ".$status."<br />";
						
					
					} else{
						
						$slug = createSlug($prod['B1_DESC']);		
						$categoria = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH1']));
						$categoria2 = $this->Categoria_model->get_categoria_by_codigo_portal(trim($prod['B1_ZZLINH2']));
						
						
						
						$params = array(
							'ref' => trim($prod['B1_COD']),
							'nome' => trim($prod['B1_DESC']),
							'slug' => $slug,
							'categoria_id' => $categoria['categoria_id'],
							'categoria_id2' => $categoria2['categoria_id'],
							'qtdlote' => $prod['B1_ZZQTWEB'],
							'status' => $status,
						);
						
						$produto_id = $this->Produto_model->update_produto_portal($check['produto_id'], $params);
						
						echo "Atualizou: ".$prod['B1_COD']." - ".$prod['B1_DESC']." - ".$prod['B1_ZZQTWEB']."status: ".$status."<br />";


					}
					
					$this->load->model('Tabela_model');
					$tabelas = $this->Tabela_model->get_all_tabelas();
					
					foreach($tabelas as $tabela){
					
						$pro = $this->Produto_model->get_produto_by_ref($prod['B1_COD']);
					
						$check = $this->Preco_model->get_preco_by_produto_tabela($pro['produto_id'], $tabela['tabela_id']);
						
				
						$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
						
						$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($pro['ref'], $tab['codigo']);
						
						if($preco['DA1_PRCVEN'])
							$prc = $preco['DA1_PRCVEN'];
						else
							$prc = 0;
							
						if(!$check){
							
							
							
							$params = array(
								'produto_id' => $pro['produto_id'],
								'tabela_id' => $tabela['tabela_id'],
								'preco' => $prc,
							);
							$this->Preco_model->add_preco($params);
							
							echo "Inseriu o preco<br />";
							
						
						} else{
							
							
							
							$params = array(
								'produto_id' => $pro['produto_id'],
								'tabela_id' => $tabela['tabela_id'],
								'preco' => $prc,
							);
							
							$this->Preco_model->update_preco($check['preco_id'], $params);
							
							echo "Atualizou o preço<br />";


						}
						
					}
				}
				
				
			}
			
			echo '<script>document.getElementById("loader").style.display = "none";</script>';
			echo '<script>alert("Produto Atualizado com sucesso! \n" + "Já pode sair da página.");</script>';
			
		}
		
		
    }
	
	
	
	function atualiza_cliente(){
    	

		function createSlug($str, $delimiter = '-'){

			$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
			return $slug;
		
		} 
	
		$this->load->model('Cliente_model');
		$clientes_totvs = $this->Produto_model->get_cliente_totvs();
		
		//print_r($clientes_totvs);
		
		
		
		

    	foreach($clientes_totvs as $c){
    		
			
			$check = $this->Cliente_model->get_cliente_by_cgc($c['A1_CGC']);
			
			
			if($c['A1_MSBLQL'] == 2)
				$status = 1;
			else
				$status = 0;
			
			if($c['A1_TABELA'] == '002'){
				$tabela = 15737;
			}
			
			if($c['A1_TABELA'] == '050'){
				$tabela = 15740;
			}
			
			if($c['A1_TABELA'] == '069'){
				$tabela = 15739;
			}
			
			if($c['A1_TABELA'] == '070'){
				$tabela = 15738;
			}
			
			if(!$check){
			
					
				
				
				$params = array(
					'codigo' => trim($c['A1_COD']),
					'nome' => trim($c['A1_NOME']),
					'cpf' => trim($c['A1_CGC']),
					'rede' => trim($c['A1_LOJA']),
					'ddd' => $c['A1_DDD'],
					'telefone' => $c['A1_TEL'],
					'e_mail' => $c['A1_EMAIL'],
					'senha' => md5(trim($c['A1_ZZPASSC'])),
					'endereco' => $c['A1_END'],
					'bairro' => $c['A1_BAIRRO'],
					'estado' => $c['A1_EST'],
					'cep' => $c['A1_CEP'],
					'cidade' => $c['A1_MUN'],
					'status' => $status,
					'tabela' => $tabela,
					'codigovend1' => $c['A1_VEND'],
					'email_vendedor' => $c['A1_ZZVEMAI'],
					
				);
				
				$cliente_id = $this->Cliente_model->add_cliente($params);
				
				echo "Inseriu: ".$c['A1_COD']." - ".$c['A1_CGC']." - ".$c['A1_ZZPASSC']." - ". $c['A1_NOME']."-".$cliente_id."<br />";
				
			
			} else{
				
				
				
				$params = array(
					'codigo' => trim($c['A1_COD']),
					'nome' => trim($c['A1_NOME']),
					'cpf' => trim($c['A1_CGC']),
					'rede' => trim($c['A1_LOJA']),
					'ddd' => $c['A1_DDD'],
					'telefone' => $c['A1_TEL'],
					'e_mail' => $c['A1_EMAIL'],
					'senha' => md5(trim($c['A1_ZZPASSC'])),
					'tabela' => $c['A1_TABELA'],
					'endereco' => $c['A1_END'],
					'bairro' => $c['A1_BAIRRO'],
					'estado' => $c['A1_EST'],
					'cep' => $c['A1_CEP'],
					'cidade' => $c['A1_MUN'],
					'status' => $status,
					'tabela' => $tabela,
					'codigovend1' => $c['A1_VEND'],
					'email_vendedor' => $c['A1_ZZVEMAI'],
				);
				
				if($this->Cliente_model->update_cliente($check['cliente_id'], $params))
					echo "Atualizou: ".$c['A1_COD']." - ".$c['A1_CGC']." - ".$c['A1_ZZPASSC']." - ". $c['A1_NOME']." - tabela:  ". $c['A1_TABELA']."-".$check['cliente_id']."<br />";
				else
					echo "Nao atualizou<br />";

			}
			
			
    	}
		
		echo "<script>location.reload();</script>";
		
		
		
    }
	
	
	
	
	function atualiza_cli(){
    	
		?>
			<h1 style="font-size:14px;">ATUALIZAÇÃO DE CLIENTE INDIVIDUAL</h1>
			<form action="" method="GET">
				<input type="text" name="codigo" placeholder="Codigo do Cliente" />
				<input type="submit" value="ATUALIZAR">
			</form>
			
		<?php
		
		if($this->input->get('codigo')){
				
			function createSlug($str, $delimiter = '-'){

				$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
				return $slug;
			
			} 
		
			$this->load->model('Cliente_model');
			$clientes_totvs = $this->Produto_model->get_cliente_totvs_by_codigo($this->input->get('codigo'));
			
			//print_r($clientes_totvs);
			
			
			
			if(!$clientes_totvs){
				echo "Não econtramos nenhum cliente com esse codigo na TOTVS.";
			}

			foreach($clientes_totvs as $c){
				
				
				$check = $this->Cliente_model->get_cliente_by_cgc($c['A1_CGC']);
				
				
				if($c['A1_MSBLQL'] == 2)
					$status = 1;
				else
					$status = 0;
				
				
				if($c['A1_TABELA'] == '002'){
					$tabela = 15737;
				}
				
				if($c['A1_TABELA'] == '050'){
					$tabela = 15740;
				}
				
				if($c['A1_TABELA'] == '069'){
					$tabela = 15739;
				}
				
				if($c['A1_TABELA'] == '070'){
					$tabela = 15738;
				}
				
				
				
				
				if(!$check){
				
						
					
					$params = array(
						'codigo' => trim($c['A1_COD']),
						'nome' => trim($c['A1_NOME']),
						'cpf' => trim($c['A1_CGC']),
						'loja' => trim($c['A1_LOJA']),
						'ddd' => $c['A1_DDD'],
						'telefone' => $c['A1_TEL'],
						'e_mail' => $c['A1_EMAIL'],
						'senha' => md5(trim($c['A1_ZZPASSC'])),
						'endereco' => $c['A1_END'],
						'bairro' => $c['A1_BAIRRO'],
						'estado' => $c['A1_EST'],
						'cep' => $c['A1_CEP'],
						'cidade' => $c['A1_MUN'],
						'status' => $status,
						'tabela' => $tabela,
						'codigovend1' => $c['A1_VEND'],
						'email_vendedor' => $c['A1_ZZVEMAI'],
						
					);
					
					$cliente_id = $this->Cliente_model->add_cliente($params);
					
					echo "Inseriu: ".$c['A1_COD']." - ".$c['A1_CGC']." - ".$c['A1_ZZPASSC']." - ". $c['A1_NOME']."-".$cliente_id."<br />";
					
				
				} else{
					
					
					
					$params = array(
						'codigo' => trim($c['A1_COD']),
						'nome' => trim($c['A1_NOME']),
						'cpf' => trim($c['A1_CGC']),
						'loja' => trim($c['A1_LOJA']),
						'ddd' => $c['A1_DDD'],
						'telefone' => $c['A1_TEL'],
						'e_mail' => $c['A1_EMAIL'],
						'senha' => md5(trim($c['A1_ZZPASSC'])),
						'tabela' => $c['A1_TABELA'],
						'endereco' => $c['A1_END'],
						'bairro' => $c['A1_BAIRRO'],
						'estado' => $c['A1_EST'],
						'cep' => $c['A1_CEP'],
						'cidade' => $c['A1_MUN'],
						'status' => $status,
						'tabela' => $tabela,
						'codigovend1' => $c['A1_VEND'],
						'email_vendedor' => $c['A1_ZZVEMAI'],
					);
					
					if($this->Cliente_model->update_cliente($check['cliente_id'], $params))
						echo "O cliente ".trim($c['A1_NOME'])." foi atualizado.";
					else
						echo "Nao atualizou<br />";

				}
				
				
				
				
			}
		
		
		} 
		
		
    }
	
	
	function atualiza_cliente_portal(){
    	

		function createSlug($str, $delimiter = '-'){

			$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
			return $slug;
		
		} 
	
		$this->load->model('Cliente_model');
		$clientes_totvs = $this->Produto_model->get_cliente_totvs();
		
		
		

    	foreach($clientes_totvs as $c){
    		
			
			$check = $this->Cliente_model->get_cliente_by_cgc($c['A1_CGC']);
			
			
			if($c['A1_MSBLQL'] == 2)
				$status = 1;
			else
				$status = 0;
			
			if(!$check){
			
					
				
				
				$params = array(
					'codigo' => trim($c['A1_COD']),
					'nome' => trim($c['A1_NOME']),
					'cpf' => trim($c['A1_CGC']),
					'loja' => trim($c['A1_LOJA']),
					'ddd' => $c['A1_DDD'],
					'telefone' => $c['A1_TEL'],
					'e_mail' => $c['A1_EMAIL'],
					'senha' => trim($c['A1_ZZPASSC']),
					'endereco' => $c['A1_END'],
					'bairro' => $c['A1_BAIRRO'],
					'estado' => $c['A1_ESTADO'],
					'cep' => $c['A1_CEP'],
					'cidade' => $c['A1_MUN'],
					'status' => $status,
					'email_vendedor' => $c['A1_ZZVEMAI'],
					
				);
				
				$cliente_id = $this->Cliente_model->add_cliente($params);
				
				echo "Inseriu: ".$c['A1_COD']." - ".$c['A1_CGC']." - ".$c['A1_ZZPASSC']." - ". $c['A1_NOME']."-".$cliente_id."<br />";
				
			
			} else{
				
				
				
				$params = array(
					'codigo' => trim($c['A1_COD']),
					'nome' => trim($c['A1_NOME']),
					'cpf' => trim($c['A1_CGC']),
					'loja' => trim($c['A1_LOJA']),
					'ddd' => $c['A1_DDD'],
					'telefone' => $c['A1_TEL'],
					'e_mail' => $c['A1_EMAIL'],
					'senha' => trim($c['A1_ZZPASSC']),
					'tabela' => $c['A1_TABELA'],
					'endereco' => $c['A1_END'],
					'bairro' => $c['A1_BAIRRO'],
					'estado' => $c['A1_ESTADO'],
					'cep' => $c['A1_CEP'],
					'cidade' => $c['A1_MUN'],
					'status' => $status,
					'email_vendedor' => $c['A1_ZZVEMAI'],
				);
				
				if($this->Cliente_model->update_cliente($check['cliente_id'], $params))
					echo "Atualizou: ".$c['A1_COD']." - ".$c['A1_CGC']." - ".$c['A1_ZZPASSC']." - ". $c['A1_NOME']."-".$check['cliente_id']."<br />";
				else
					echo "Nao atualizou<br />";

			}
			
			
    	}
		
		echo "<script>location.reload();</script>";
		
		
		
    }
	
	
	
	
	function atualiza_tabela(){
    	

		function createSlug($str, $delimiter = '-'){

			$slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
			return $slug;
		
		} 
	
		$this->load->model('Tabela_model');
		$tabelas_totvs = $this->Produto_model->get_tabelas_totvs();
		
		//print_r($tabelas_totvs);
		
		
		
		
		
		
		
		

    	foreach($tabelas_totvs as $c){
    		
			
			$check = $this->Tabela_model->get_tabela_by_codigo($c['DA0_CODTAB']);
			
			
			
			if(!$check){
			
					
				
				
				$params = array(
					'codigo' => trim($c['DA0_CODTAB']),
					'descricao' => trim($c['DA0_DESCRI']),
					
					
				);
				
				$cliente_id = $this->Tabela_model->add_tabela($params);
				
				echo "Inseriu: ".$c['DA0_CODTAB']." - ".$c['DA0_DESCRI']."<br />";
				
			
			} else{
				
				
				
				$params = array(
					'codigo' => trim($c['DA0_CODTAB']),
					'descricao' => trim($c['DA0_DESCRI']),
				);
				
				$produto_id = $this->Tabela_model->update_tabela($check['tabela_id'], $params);
				
				echo "Atualizou: ".$c['DA0_CODTAB']." - ".$c['DA0_DESCRI']."<br />";


			}
			
			
    	}
		
		
		
		
		
    }
	
	function teste(){
		$this->load->model('Tabela_model');
		
		?>
			<h1 style="font-size:14px;">ATUALIZAÇÃO DE PREÇOS POR TABELA</h1>
			<form action="" method="GET">
				<input type="text" name="codigo_tab" placeholder="Codigo da Tabela" />
				<input type="submit" onclick="document.getElementById('loader').style.display = 'block'" value="ATUALIZAR">
			</form>
			<div id="loader" style="width: 100%; height: 100%; background-color: #dcdcdc; opacity: 50%; display: none;z-index: 99999; position: fixed; margin-top: -70px;"><h1 style="margin-left: 40%; margin-top: 20%;">Processando</h1><h2 style="margin-left: 40%;">Por favor, não feche a página.</h2></div>
		<?php
		
		
		
		if($this->input->get('codigo_tab')){
		
			echo '<pre>';
			$produtos = $this->Produto_model->get_all_produto();
			$tabela = $this->Tabela_model->get_tabela_by_codigo($this->input->get('codigo_tab'));
			
			
			
			
			foreach($produtos as $p){
				
				
				
				$prod = $this->Produto_model->get_produto($p['produto_id']);
				
				
				//$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], $tab['codigo']);
				$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], '070');
				echo $p['produto_id'] . '-' .$tabela['tabela_id'] .'-'.$preco['DA1_PRCVEN'].'<br>';
			}
			
			echo '<script>document.getElementById("loader").style.display = "none";</script>';
			echo '<script>alert("Preços Atualizados com sucesso! \n" + "Já pode sair da página.");</script>';
		}
		
		/*
		
		
		
		
		$this->load->model('Tabela_model');
		$this->load->model('Preco_model');
		$tabelas_totvs = $this->Produto_model->get_tabelas_totvs();
		
		$i = 0;
    	foreach($tabelas_totvs as $c){
			if($i < 2){
			
			$tabela = $this->Tabela_model->get_tabela_by_codigo( $c['DA0_CODTAB']);
			$produtos = $this->Produto_model->get_all_produto();
			
			
			
			
			
				foreach($produtos as $p){
					
					if($i < 2){
						$check = $this->Preco_model->get_preco_by_produto_tabela($p['produto_id'], $tabela['tabela_id']);
						
						$prod = $this->Produto_model->get_produto($p['produto_id']);
						$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
						
						$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], $tab['codigo']);
						
						
						echo $p['produto_id'] . '-' .$tabela['tabela_id'] .'-'.$preco['DA1_PRCVEN'].'<br>';
					
					
						break 2;
					}
					
				}
				$i++;
			
			}
			
    	}
		*/
		
		
	}
	
	function atualiza_preco_by_tabela(){
		
			$this->load->model('Tabela_model');
			$this->load->model('Preco_model');
			?>
				<h1 style="font-size:14px;">ATUALIZAÇÃO DE PREÇOS POR TABELA</h1>
				<form action="" method="GET">
					<input type="text" name="codigo_tab" placeholder="Codigo da Tabela" />
					<input type="submit" onclick="document.getElementById('loader').style.display = 'block'" value="ATUALIZAR">
				</form>
				<div id="loader" style="width: 100%; height: 100%; background-color: #dcdcdc; opacity: 50%; display: none;z-index: 99999; position: fixed; margin-top: -70px;"><h1 style="margin-left: 40%; margin-top: 20%;">Processando</h1><h2 style="margin-left: 40%;">Por favor, não feche a página.</h2></div>
			<?php
			
			
			
		if($this->input->get('codigo_tab')){
			$tabela = $this->Tabela_model->get_tabela_by_codigo($this->input->get('codigo_tab'));
			//var_dump($tabela);
			$produtos = $this->Produto_model->get_all_produto();
			
			print_r($produtos);
		
			
			
			foreach($produtos as $p){
				
				$check = $this->Preco_model->get_preco_by_produto_tabela($p['produto_id'], $tabela['tabela_id']);
				
				$prod = $this->Produto_model->get_produto($p['produto_id']);
				$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
				
				$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], $tab['codigo']);
				
				if($preco['DA1_PRCVEN'])
					$prc = $preco['DA1_PRCVEN'];
				else
					$prc = 0;
					
				if(!$check){
					
					
					
					$params = array(
						'produto_id' => $p['produto_id'],
						'tabela_id' => $tabela['tabela_id'],
						'preco' => $prc,
					);
					$this->Preco_model->add_preco($params);
					
					echo "Inseriu o preco<br />";
					echo $p['produto_id'] . '-' .$tabela['tabela_id'] .'-'.$prc.'<br>';
				
				} else{
					
					
					
					$params = array(
						'produto_id' => $p['produto_id'],
						'tabela_id' => $tabela['tabela_id'],
						'preco' => $prc,
					);
					
					$this->Preco_model->update_preco($check['preco_id'], $params);
					
					echo "Atualizou o preço<br />";
					echo $p['produto_id'] . '-' .$tabela['tabela_id'] .'-'.$prc.'<br>';


				}
				
			}
			
			echo '<script>document.getElementById("loader").style.display = "none";</script>';
			echo '<script>alert("Preços Atualizados com sucesso! \n" + "Já pode sair da página.");</script>';
		}
			
	}
	
	
	function atualiza_preco(){
    	

		$this->load->model('Tabela_model');
		$this->load->model('Preco_model');
		$tabelas_totvs = $this->Produto_model->get_tabelas_totvs();
		
		print_r($tabelas_totvs);
		
		
		
    	foreach($tabelas_totvs as $c){
    		
			
			$tabela = $this->Tabela_model->get_tabela_by_codigo( $c['DA0_CODTAB']);
			$produtos = $this->Produto_model->get_all_produto();
			
			
			foreach($produtos as $p){
				
				$check = $this->Preco_model->get_preco_by_produto_tabela($p['produto_id'], $tabela['tabela_id']);
				
				$prod = $this->Produto_model->get_produto($p['produto_id']);
				$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
				
				$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], $tab['codigo']);
				
				if($preco['DA1_PRCVEN'])
					$prc = $preco['DA1_PRCVEN'];
				else
					$prc = 0;
					
				if(!$check){
					
					
					if($tabela){
						$params = array(
							'produto_id' => $p['produto_id'],
							'tabela_id' => $tabela['tabela_id'],
							'preco' => $prc,
						);
						$this->Preco_model->add_preco($params);
						
						echo "Inseriu o preco<br />";
						
					}
					
					
					
				
				} else{
					
					
					
					$params = array(
						'produto_id' => $p['produto_id'],
						'tabela_id' => $tabela['tabela_id'],
						'preco' => $prc,
					);
					
					$this->Preco_model->update_preco($check['preco_id'], $params);
					
					echo "Atualizou o preço<br />";


				}
				
			}
			
			
			
			
    	}
		
		
		
		
		
    }
	
	
	
	function atualiza_preco_produto($produto){
    	

		$this->load->model('Tabela_model');
		$this->load->model('Preco_model');
		$tabelas_totvs = $this->Produto_model->get_tabelas_totvs();
		
		
		
		
    	foreach($tabelas_totvs as $c){
    		
			
			$tabela = $this->Tabela_model->get_tabela_by_codigo( $c['DA0_CODTAB']);
			$produtos = $this->Produto_model->get_all_produto_by_ref($produto);
			
			
			
			
			
			foreach($produtos as $p){
				
				echo $p['ref']."<br>";
				
				$check = $this->Preco_model->get_preco_by_produto_tabela($p['produto_id'], $tabela['tabela_id']);
				
				$prod = $this->Produto_model->get_produto($p['produto_id']);
				$tab = $this->Tabela_model->get_tabela($tabela['tabela_id']);
				
				$preco = $this->Produto_model->get_preco_totvs_by_produto_tabela($prod['ref'], $tab['codigo']);
				
				if($preco['DA1_PRCVEN'])
					$prc = $preco['DA1_PRCVEN'];
				else
					$prc = 0;
					
				if(!$check){
					
					
					
					$params = array(
						'produto_id' => $p['produto_id'],
						'tabela_id' => $tabela['tabela_id'],
						'preco' => $prc,
					);
					$this->Preco_model->add_preco($params);
					
					echo "Inseriu o preco<br />";
					
				
				} else{
					
					
					
					$params = array(
						'produto_id' => $p['produto_id'],
						'tabela_id' => $tabela['tabela_id'],
						'preco' => $prc,
					);
					
					$this->Preco_model->update_preco($check['preco_id'], $params);
					
					echo "Atualizou o preço<br />";


				}
				
				
				
			}
			
			
			
    	}
		
		
		
		
		
    }
	

    
    function add()
    {   
    
    	function createSlug($str, $delimiter = '-'){

	    $slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
	    return $slug;
	
	} 
	
	
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $this->load->model('Produto_categoria_model');
            
            $slug = createSlug($this->input->post('nome'));
            
            $check_slug = $this->Produto_model->get_produto_by_slug($slug);
            
            if($check_slug){
            	
            	for($i=1;$i<999;$i++){
            		$slug = createSlug($this->input->post('nome'))."-".$i;
            		if(!$this->Produto_model->get_produto_by_slug($slug)){
            			break;
            		}
            	}
            	
            } else{
            	$slug = createSlug($this->input->post('nome'));
            }
            
            	
            
            $params = array(
				'grupo_id' => $this->input->post('grupo_id'),
				'nome' => $this->input->post('nome'),
				'ref' => $this->input->post('ref'),
				'obs' => $this->input->post('obs'),
				'slug' => $slug,
				'meta_description' => $this->input->post('meta_description'),
				'meta_keywords' => $this->input->post('meta_keywords'),
				'tags' => $this->input->post('tags'),
				'peso' => $this->input->post('peso'),
				'destaque' => $this->input->post('destaque'),
				'preco' => $this->input->post('preco'),
				'promocional' => $this->input->post('promocional'),
				'status' => $this->input->post('status'),
				'resumo' => $this->input->post('resumo'),
				'descricao' => $this->input->post('descricao'),
				'promocao' => $this->input->post('promocao'),
				'lancamento' => $this->input->post('lancamento'),
				'desativado' => $this->input->post('desativado'),
            );
            
            $produto_id = $this->Produto_model->add_produto($params);
            
            if($this->input->post('categorias')){
	            foreach($this->input->post('categorias') as $cat){
		            $params = array(
						
						'produto_id' => $produto_id,
						'categoria_id' => $cat,
		            );
		            
		            $this->Produto_categoria_model->add_produto_categoria($params);
		    }
	    }
            
            redirect('produto/sku/'.$produto_id);
        }
        else
        {
			$this->load->model('Grupo_model');
			$data['all_grupo'] = $this->Grupo_model->get_all_grupo();

			$this->load->model('Categoria_model');
            $data['config'] = $this->Config_model->get_config();
            $data['all_categorias'] = $this->Categoria_model->get_all_categorias();
            
            $data['_view'] = 'produto/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a produto
     */
    function edit($produto_id)
    {   
        // check if the produto exists before trying to edit it
        $data['produto'] = $this->Produto_model->get_produto($produto_id);
        $data['config'] = $this->Config_model->get_config();
        $this->load->model('Produto_categoria_model');
        
        
        if(isset($data['produto']['produto_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					
					
					'nome' => $this->input->post('nome'),
					'status' => $this->input->post('status'),
					'resumo' => $this->input->post('resumo'),
					'descricao' => $this->input->post('descricao'),
					'promocao' => $this->input->post('promocao'),
					'lancamento' => $this->input->post('lancamento'),
					'desativado' => $this->input->post('desativado'),
                );

                $this->Produto_model->update_produto($produto_id,$params); 
                
                
                $this->Produto_categoria_model->delete_produto_categoria_by_produto_id($produto_id);
                
                if($this->input->post('categorias')){
		            foreach($this->input->post('categorias') as $cat){
			            $params = array(
							
							'produto_id' => $produto_id,
							'categoria_id' => $cat,
			            );
			            
			            $this->Produto_categoria_model->add_produto_categoria($params);
			    }
		}
	    
                
                           
                redirect('produto/');
            }
            else
            {
				$this->load->model('Grupo_model');
				$data['all_grupo'] = $this->Grupo_model->get_all_grupo();

				$this->load->model('Categoria_model');
				$data['all_categorias'] = $this->Categoria_model->get_all_categorias();
				$data['categorias'] = $this->Produto_categoria_model->get_all_categorias_by_produto_id($produto_id);

                $data['_view'] = 'produto/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The produto you are trying to edit does not exist.');
    } 
    
    
    
    function imagens($produto_id)
    {   
        
	   		
	   $data['config'] = $this->Config_model->get_config();
	   $data['produto'] = $this->Produto_model->get_produto($produto_id);
	   $data['all_imagens'] = $this->Imagem_produto_model->get_all_imagens_by_produto_id($produto_id);
	   
	   
           $data['_view'] = 'produto/imagens';
           $this->load->view('layouts/main',$data);
            
       
    } 
    
    
    function sku($produto_id)
    {   
        
           $this->load->model('Cor_model');
           $this->load->model('Tamanho_model');
           $this->load->model('Sku_model');
           
           if($this->input->post()){
           	
           	$check_sku = $this->Sku_model->check_sku($produto_id, $this->input->post('cor_id'), $this->input->post('tamanho_id'));
           	
           	if(!$check_sku){
	           	$params = array(			
				'produto_id' => $produto_id,
				'cor_id' => $this->input->post('cor_id'),
				'tamanho_id' => $this->input->post('tamanho_id'),
				'saldo' => $this->input->post('qtd'),
				'status' => $this->input->post('status'),
			);
		} else{
			redirect('produto/sku/'.$produto_id."?msg=duplicate");
		}
			            
		$this->Sku_model->add_sku($params);
           }
           $data['produto'] = $this->Produto_model->get_produto($produto_id);
           $data['all_cores'] = $this->Cor_model->get_all_cores();
           $data['all_tamanhos'] = $this->Tamanho_model->get_all_tamanhos();
           
           $data['all_skus'] = $this->Sku_model->get_all_skus_by_produto_id($produto_id);
           
	   		
	   $data['config'] = $this->Config_model->get_config();
           $data['_view'] = 'produto/sku';
           $this->load->view('layouts/main',$data);
            
       
    } 
    
    
    
    function atualiza_saldo($sku_id, $produto_id)
    {   
        
         
           $this->load->model('Sku_model');
           
          
	   $params = array(	
	   	'saldo' => $this->input->post('saldo')
	   );		            
	   $this->Sku_model->update_sku($sku_id, $params);
          
           redirect('produto/sku/'.$produto_id);
            
       
    }
    
    
    
    function update_imagem($produto_id)
    {   
        	function save_base64_image($base64_image_string, $output_file_without_extension, $path_with_end_slash="" ) {
		          
		   
		    $splited = explode(',', substr( $base64_image_string , 5 ) , 2);
		    $mime=$splited[0];
		    $data=$splited[1];
		
		    $mime_split_without_base64=explode(';', $mime,2);
		    $mime_split=explode('/', $mime_split_without_base64[0],2);
		    if(count($mime_split)==2)
		    {
		        $extension=$mime_split[1];
		        if($extension=='jpeg')$extension='jpg';
		        //if($extension=='javascript')$extension='js';
		        //if($extension=='text')$extension='txt';
		        $output_file_with_extension=$output_file_without_extension.'.'.$extension;
		    }
		    file_put_contents( $path_with_end_slash . $output_file_with_extension, base64_decode($data) );
		    return $output_file_with_extension;
		}

        	$_POST = json_decode(file_get_contents("php://input"),true);
		$imagem = $_POST['imagem'];
		
		  $filename = save_base64_image($imagem, time(), "assets/uploads/"); 
		
	   		
	   	$params = array(
			'imagem' => base_url('assets/uploads/'.$filename),
		);

                $this->Produto_model->update_produto($produto_id,$params);
                
                
                
                
            
       
    } 
    
    
    
    
    function add_imagem_secundaria($produto_id)
        { 
        	$this->load->model('Imagem_produto_model');
  
        	function save_base64_image($base64_image_string, $output_file_without_extension, $path_with_end_slash="" ) {
		          
		   
		    $splited = explode(',', substr( $base64_image_string , 5 ) , 2);
		    $mime=$splited[0];
		    $data=$splited[1];
		
		    $mime_split_without_base64=explode(';', $mime,2);
		    $mime_split=explode('/', $mime_split_without_base64[0],2);
		    if(count($mime_split)==2)
		    {
		        $extension=$mime_split[1];
		        if($extension=='jpeg')$extension='jpg';
		        //if($extension=='javascript')$extension='js';
		        //if($extension=='text')$extension='txt';
		        $output_file_with_extension=$output_file_without_extension.'.'.$extension;
		    }
		    file_put_contents( $path_with_end_slash . $output_file_with_extension, base64_decode($data) );
		    return $output_file_with_extension;
		}
		
		

        	$_POST = json_decode(file_get_contents("php://input"),true);
		$imagem = $_POST['imagem'];
		
		$filename = save_base64_image($imagem, time(), "assets/uploads/"); 
		
	   		
	   	$params = array(
			'url' => base_url('assets/uploads/'.$filename),
			'produto_id' => $produto_id
		);

                $this->Imagem_produto_model->add_imagem_produto($params);
           
       
    } 
    
    
    

    /*
     * Deleting produto
     */
    function remove($produto_id)
    {
        $produto = $this->Produto_model->get_produto($produto_id);

        // check if the produto exists before trying to delete it
        if(isset($produto['produto_id']))
        {
            $this->Produto_model->delete_produto($produto_id);
            redirect('produto/index');
        }
        else
            show_error('The produto you are trying to delete does not exist.');
    }
    
}
