<?php

 
class Pedido extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Pedido_model');
        $this->load->model('Produto_pedido_model');
    } 

   
    function index()
    {
        $data['config'] = $this->Config_model->get_config();
        $data['pedido'] = $this->Pedido_model->get_all_pedido();
        
        $data['_view'] = 'pedido/index';
        $this->load->view('layouts/main',$data);
    }

    
    function add()
    {   
        $data['config'] = $this->Config_model->get_config();
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'cliente_id' => $this->input->post('cliente_id'),
				'codigo' => $this->input->post('codigo'),
				'data' => $this->input->post('data'),
				'status' => $this->input->post('status'),
            );
            
            $pedido_id = $this->Pedido_model->add_pedido($params);
            redirect('pedido/index');
        }
        else
        {
			$this->load->model('Cliente_model');
			$data['all_cliente'] = $this->Cliente_model->get_all_cliente();
            
            $data['_view'] = 'pedido/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    
    function edit($pedido_id)
    {   
        $data['config'] = $this->Config_model->get_config();
        // check if the pedido exists before trying to edit it
        $data['pedido'] = $this->Pedido_model->get_pedido($pedido_id);
        
        $data['produtos'] = $this->Produto_pedido_model->get_all_produtos_by_pedido_id($pedido_id);
        
        
        if(isset($data['pedido']['pedido_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'cliente_id' => $this->input->post('cliente_id'),
					'codigo' => $this->input->post('codigo'),
					'data' => $this->input->post('data'),
					'status' => $this->input->post('status'),
                );

                $this->Pedido_model->update_pedido($pedido_id,$params);            
                redirect('pedido/index');
            }
            else
            {
		$this->load->model('Cliente_model');
		$data['all_cliente'] = $this->Cliente_model->get_all_clientes();

                $data['_view'] = 'pedido/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The pedido you are trying to edit does not exist.');
    } 
    
    
    
    function cancela($pedido_id)
    {   
        
                $params = array(
			'status' => 0,
                );

                $this->Pedido_model->update_pedido($pedido_id,$params); 
                
                redirect('pedido');           
                
    } 
    
    
    function confirma_pagamento($pedido_id)
    {   
        
                $params = array(
			'status' => 2,
                );

                $this->Pedido_model->update_pedido($pedido_id,$params); 
                
                redirect('pedido');           
                
    }
    
    
    

    /*
     * Deleting pedido
     */
    function remove($pedido_id)
    {
        $pedido = $this->Pedido_model->get_pedido($pedido_id);

        // check if the pedido exists before trying to delete it
        if(isset($pedido['pedido_id']))
        {
            $this->Pedido_model->delete_pedido($pedido_id);
            redirect('pedido/index');
        }
        else
            show_error('The pedido you are trying to delete does not exist.');
    }
    
}
