<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */
 
class Cor extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Cor_model');
    } 

    /*
     * Listing of cor
     */
    function index()
    {
        $data['config'] = $this->Config_model->get_config();
        $data['cor'] = $this->Cor_model->get_all_cores();
        
        $data['_view'] = 'cor/index';
        $this->load->view('layouts/main',$data);
    }

    /*
     * Adding a new cor
     */
    function add()
    {   
        $data['config'] = $this->Config_model->get_config();
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'descricao' => $this->input->post('descricao'),
				'hexa' => $this->input->post('hexa'),
				'url' => "",
            );
            
            $cor_id = $this->Cor_model->add_cor($params);
            redirect('cor/index');
        }
        else
        {            
            $data['_view'] = 'cor/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a cor
     */
    function edit($cor_id)
    {   
        $data['config'] = $this->Config_model->get_config();
        // check if the cor exists before trying to edit it
        $data['cor'] = $this->Cor_model->get_cor($cor_id);
        
        if(isset($data['cor']['cor_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'descricao' => $this->input->post('descricao'),
					'hexa' => $this->input->post('hexa'),
					'url' => "",
                );

                $this->Cor_model->update_cor($cor_id,$params);            
                redirect('cor/index');
            }
            else
            {
                $data['_view'] = 'cor/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The cor you are trying to edit does not exist.');
    } 

    /*
     * Deleting cor
     */
    function remove($cor_id)
    {
        $cor = $this->Cor_model->get_cor($cor_id);

        // check if the cor exists before trying to delete it
        if(isset($cor['cor_id']))
        {
            $this->Cor_model->delete_cor($cor_id);
            redirect('cor/index');
        }
        else
            show_error('The cor you are trying to delete does not exist.');
    }
    
}
