<?php
 
class Cliente extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Cliente_model');
    } 

    /*
     * Listing of cliente
     */
    function index()
    {
        $data['cliente'] = $this->Cliente_model->get_all_clientes();
        $data['config'] = $this->Config_model->get_config();
        
        
        $data['_view'] = 'cliente/index';
        $this->load->view('layouts/main',$data);
    }

    /*
     * Adding a new cliente
     */
    function add()
    {   
        $data['config'] = $this->Config_model->get_config();
        
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'nome' => $this->input->post('nome'),
				'cpf' => $this->input->post('cpf'),
				'telefone' => $this->input->post('telefone'),
				'celular' => $this->input->post('celular'),
				'endereco' => $this->input->post('endereco'),
				'numero' => $this->input->post('numero'),
				'bairro' => $this->input->post('bairro'),
				'cidade' => $this->input->post('cidade'),
				'estado' => $this->input->post('estado'),
				'cep' => $this->input->post('cep'),
				'complemento' => $this->input->post('complemento'),
				'status' => $this->input->post('status'),
            );
            
            $cliente_id = $this->Cliente_model->add_cliente($params);
            redirect('cliente/index');
        }
        else
        {            
            $data['_view'] = 'cliente/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a cliente
     */
    function edit($cliente_id)
    {   
        $data['config'] = $this->Config_model->get_config();
        
        // check if the cliente exists before trying to edit it
        $data['cliente'] = $this->Cliente_model->get_cliente($cliente_id);
        
        if(isset($data['cliente']['cliente_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'nome' => $this->input->post('nome'),
					'cpf' => $this->input->post('cpf'),
					'telefone' => $this->input->post('telefone'),
					'celular' => $this->input->post('celular'),
					'endereco' => $this->input->post('endereco'),
					'numero' => $this->input->post('numero'),
					'bairro' => $this->input->post('bairro'),
					'cidade' => $this->input->post('cidade'),
					'estado' => $this->input->post('estado'),
					'cep' => $this->input->post('cep'),
					'complemento' => $this->input->post('complemento'),
					'status' => $this->input->post('status'),
                );

                $this->Cliente_model->update_cliente($cliente_id,$params);            
                redirect('cliente/index');
            }
            else
            {
                $data['_view'] = 'cliente/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The cliente you are trying to edit does not exist.');
    } 

    /*
     * Deleting cliente
     */
    function remove($cliente_id)
    {
        $cliente = $this->Cliente_model->get_cliente($cliente_id);

        // check if the cliente exists before trying to delete it
        if(isset($cliente['cliente_id']))
        {
            $this->Cliente_model->delete_cliente($cliente_id);
            redirect('cliente/index');
        }
        else
            show_error('The cliente you are trying to delete does not exist.');
    }
    
}
