<?php

 
class Categoria extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Categoria_model');
    } 

    /*
     * Listing of categoria
     */
    function index()
    {
    	$data['config'] = $this->Config_model->get_config();
        $data['categoria'] = $this->Categoria_model->get_all_categorias();
        
        $data['_view'] = 'categoria/index';
        $this->load->view('layouts/main',$data);
    }
	
	
    function update_imagem($categoria_id)
    {   
        	function save_base64_image($base64_image_string, $output_file_without_extension, $path_with_end_slash="" ) {
		          
		   
		    $splited = explode(',', substr( $base64_image_string , 5 ) , 2);
		    $mime=$splited[0];
		    $data=$splited[1];
		
		    $mime_split_without_base64=explode(';', $mime,2);
		    $mime_split=explode('/', $mime_split_without_base64[0],2);
		    if(count($mime_split)==2)
		    {
		        $extension=$mime_split[1];
		        if($extension=='jpeg')$extension='jpg';
		        //if($extension=='javascript')$extension='js';
		        //if($extension=='text')$extension='txt';
		        $output_file_with_extension=$output_file_without_extension.'.'.$extension;
		    }
		    file_put_contents( $path_with_end_slash . $output_file_with_extension, base64_decode($data) );
		    return $output_file_with_extension;
		}

        	$_POST = json_decode(file_get_contents("php://input"),true);
			$imagem = $_POST['imagem'];
		
		  $filename = save_base64_image($imagem, time(), "assets/uploads/"); 
		
	   		
	   	$params = array(
			'imagem' => base_url('assets/uploads/'.$filename),
		);

                $this->Categoria_model->update_categoria($categoria_id,$params);
                
                
                
                
            
       
    } 
    
	
	
    /*
     * Adding a new categoria
     */
    function add()
    {   
    	$data['config'] = $this->Config_model->get_config();
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'nome' => $this->input->post('nome'),
				'imagem' => $this->input->post('imagem'),
				'status' => 1,
				'descricao' => $this->input->post('descricao'),
            );
            
            $categoria_id = $this->Categoria_model->add_categoria($params);
            redirect('categoria/index');
        }
        else
        {            
            $data['_view'] = 'categoria/add';
            $this->load->view('layouts/main',$data);
        }
    }  

    /*
     * Editing a categoria
     */
    function edit($categoria_id)
    {   
    	$data['config'] = $this->Config_model->get_config();
    	
        // check if the categoria exists before trying to edit it
        $data['categoria'] = $this->Categoria_model->get_categoria($categoria_id);
        
        if(isset($data['categoria']['categoria_id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'nome' => $this->input->post('nome'),
					'imagem' => $this->input->post('imagem'),
					'cor' => $this->input->post('cor'),
					'status' => $this->input->post('status'),
					'descricao' => $this->input->post('descricao'),
                );

                $this->Categoria_model->update_categoria($categoria_id,$params);            
                redirect('categoria/index');
            }
            else
            {
                $data['_view'] = 'categoria/edit';
                $this->load->view('layouts/main',$data);
            }
        }
        else
            show_error('The categoria you are trying to edit does not exist.');
    } 

    /*
     * Deleting categoria
     */
    function remove($categoria_id)
    {
        $categoria = $this->Categoria_model->get_categoria($categoria_id);

        // check if the categoria exists before trying to delete it
        if(isset($categoria['categoria_id']))
        {
            $this->Categoria_model->delete_categoria($categoria_id);
            redirect('categoria/index');
        }
        else
            show_error('The categoria you are trying to delete does not exist.');
    }
    
}
