<?php

 
class Atualiza extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Pedido_model');
		$this->load->model('Produto_pedido_model');
        
    }
	
	
	function destravar_pedidos(){
		
		$this->load->model('Pedido_model');
		
		$pedidos_nulos = $this->Pedido_model->get_all_pedidos_nulos();
		foreach($pedidos_nulos as $pedido){
			$params = array(
				'codigo' => '000000',	
			);
				
			$this->Pedido_model->update_pedido($pedido['pedido_id'], $params);
			echo "pedido:".$pedido['pedido_id']."<br />";
		}
	}
	function titulos(){
		$this->load->model('Titulo_model');
		
		$titulos = $this->Titulo_model->get_all_titulos_totvs();
		
		//delete all registers
		$this->Titulo_model->delete_all_portal();
	
		$titulo_id = 1;
		foreach($titulos as $titulo){
			
			$params = array(
				'titulo_id' => $titulo_id,
				'cod_cliente' => $titulo['A1_COD'],
				'n_titulo' => $titulo['N_TITULO'],
				'parcela' => $titulo['E1_PARCELA'],
				'vencimento' => substr($titulo['VENCIMENTO'],6,4)."-".substr($titulo['VENCIMENTO'],3,2)."-".substr($titulo['VENCIMENTO'],0,2),
				'tipo' => $titulo['TIPO'],
				'saldo' => $titulo['E1_SALDO'],
				'total' => $titulo['E1_VALOR'],
				'pedido' => $titulo['PEDIDO']
			);
			
			$this->Titulo_model->add_titulo_portal($params);
			echo "Titulo inserido com sucesso<br>"; 
			$titulo_id++;
		}
		
		
		
	}
	
	
	
	
	
	function distribuidores(){
		$this->load->model('Cliente_model');
		
		
		echo "atualiza distribuidores";
		
		$distribuidores = $this->Cliente_model->get_all_distribuidores_totvs();
		
		foreach($distribuidores as $distribuidor){
			
			$params = array(
				'distribuidor_site_titulo' => $distribuidor['A1_NOME'],
				'distribuidor_site_endereco' => $distribuidor['A1_END'],
				'distribuidor_site_numero' => "",
				'distribuidor_site_bairro' => $distribuidor['A1_BAIRRO'],
				'distribuidor_site_cidade' => $distribuidor['A1_MUN'],
				'distribuidor_site_estado' => $distribuidor['A1_EST'],
				'distribuidor_site_cep' => $distribuidor['A1_CEP'],
				'distribuidor_site_email' => $distribuidor['A1_EMAIL'],
				'distribuidor_site_whatsapp' => $distribuidor['A1_DDD']." ".$distribuidor['A1_TELEX'],
				'distribuidor_site_status' => 1,
				
				
			);
			if($this->Cliente_model->add_distribuidor($params)){
				echo "Incluido com sucesso<br>";
			}else{
				echo "Erro ao incluir<br>";
			}
		}
		
		/*
		$titulos = $this->Titulo_model->get_all_titulos_totvs();
		
		//delete all registers
		$this->Titulo_model->delete_all_portal();
	
		$titulo_id = 1;
		foreach($titulos as $titulo){
			
			$params = array(
				'titulo_id' => $titulo_id,
				'cod_cliente' => $titulo['A1_COD'],
				'n_titulo' => $titulo['N_TITULO'],
				'parcela' => $titulo['E1_PARCELA'],
				'vencimento' => substr($titulo['VENCIMENTO'],6,4)."-".substr($titulo['VENCIMENTO'],3,2)."-".substr($titulo['VENCIMENTO'],0,2),
				'tipo' => $titulo['TIPO'],
				'saldo' => $titulo['E1_SALDO'],
				'total' => $titulo['E1_VALOR'],
				'pedido' => $titulo['PEDIDO']
			);
			
			$this->Titulo_model->add_titulo_portal($params);
			echo "Titulo inserido com sucesso<br>"; 
			$titulo_id++;
		}
		
		
		*/
	}
	
	function titulos_cliente($cod_cliente){
		$this->load->model('Titulo_model');
		
		$titulos = $this->Titulo_model->get_all_titulos_totvs_cliente($cod_cliente);
		
		//delete all registers
		$this->Titulo_model->delete_all_portal();
	
		$titulo_id = 1;
		foreach($titulos as $titulo){
			
			$params = array(
				'titulo_id' => $titulo_id,
				'cod_cliente' => $titulo['A1_COD'],
				'n_titulo' => $titulo['N_TITULO'],
				'parcela' => $titulo['E1_PARCELA'],
				'vencimento' => substr($titulo['VENCIMENTO'],6,4)."-".substr($titulo['VENCIMENTO'],3,2)."-".substr($titulo['VENCIMENTO'],0,2),
				'tipo' => $titulo['TIPO'],
				'saldo' => $titulo['E1_SALDO'],
				'total' => $titulo['E1_VALOR'],
				'pedido' => $titulo['PEDIDO']
			);
			
			$this->Titulo_model->add_titulo_portal($params);
			echo "Titulo inserido com sucesso<br>"; 
			$titulo_id++;
		}
		
		
		
	}
	
	function titulo_por_cliente(){
		$this->load->model('Titulo_model');
		
		?>
			<h1 style="font-size:14px;">ATUALIZAÇÃO DE TÍTULOS POR CLIENTE</h1>
			<form action="" method="GET">
				<input type="text" name="codigo_cli" placeholder="Codigo do cliente" />
				<input type="submit" value="ATUALIZAR">
			</form>
			
		<?php
		
		
		
		if($this->input->get('codigo_cli')){
		
			$titulos = $this->Titulo_model->get_all_titulos_totvs_by_cliente($this->input->get('codigo_cli'));
			
			//delete all registers
			$this->Titulo_model->delete_all_portal_by_cliente($this->input->get('codigo_cli'));
			
			$ultimo_id = $this->Titulo_model->get_ultimo_id_portal();
			$titulo_id = $ultimo_id['titulo_id'] + 1;
			foreach($titulos as $titulo){
				
				$params = array(
					'titulo_id' => $titulo_id,
					'cod_cliente' => $titulo['A1_COD'],
					'n_titulo' => $titulo['N_TITULO'],
					'parcela' => $titulo['E1_PARCELA'],
					'vencimento' => substr($titulo['VENCIMENTO'],6,4)."-".substr($titulo['VENCIMENTO'],3,2)."-".substr($titulo['VENCIMENTO'],0,2),
					'tipo' => $titulo['TIPO'],
					'saldo' => $titulo['E1_SALDO'],
					'total' => $titulo['E1_VALOR'],
					'pedido' => $titulo['PEDIDO']
				);
				
				$this->Titulo_model->add_titulo_portal($params);
				echo "Titulo inserido com sucesso<br>"; 
				$titulo_id++;
			}
		
		}
		
	}
	function cond_pag(){
		
		$this->load->model('Cond_pag_model');
		
		$cond_pags = $this->Cond_pag_model->get_all_cond_pag_totvs();
		
		//delete all registers
		$this->Cond_pag_model->delete_all_portal();
	
		$cond_pag_id = 1;
		foreach($cond_pags as $cond_pag){
			
			$params = array(
				'cond_pag_id' => $cond_pag_id,
				'cod_cond_pag' => $cond_pag['E4_CODIGO'],
				'nome' => $cond_pag['E4_DESCRI'],
				'condicao' => $cond_pag['E4_COND']
			);
			
			$this->Cond_pag_model->add_cond_pag_portal($params);
			echo "Titulo inserido com sucesso<br>"; 
		$cond_pag_id++;
		}
		
		
		
	}

	function teste_cond()
	{
		$this->load->model('Cond_pag_model');
		
		$cond_pags = $this->Cond_pag_model->get_all_cond_pag_totvs();
		
		
		echo '<pre>';
		//for($i = 0; $i < 10; $i++){
		foreach($cond_pags as $cond_pag){
			print_r($cond_pag);
		}
	
		
	}
	
	// lista 10 
	function titulos_totvs()
	{
		$this->load->model('Titulo_model');
		
		$titulos = $this->Titulo_model->get_all_titulos_totvs();
		$i = 1;
		foreach($titulos as $titulo){
			if($i <= 10){
				echo $titulo['VENCIMENTO'];
				echo '<br>';
			}else{
				break 1;
			}
			$i++;
		}
		
	}
	// lista 10 cond_pags 
	function cond_pag_totvs(){
		$this->load->model('Cond_pag_model');
		
		$cond_pags = $this->Cond_pag_model->get_all_cond_pag_totvs();
		
		$i = 1;
		foreach($cond_pags as $cond_pag){
			if($i <= 10){
				echo '<pre>';
				print_r($cond_pag);
			}else{
				break 1;
			}
			$i++;
		}
	}
	
	
	

	function estoque(){
		$this->load->model('Produto_model');
		$estoque = $this->Produto_model->get_all_estoque_totvs();

		// Prepara os dados para a API
		$produtos = [];
		foreach ($estoque as $item) {
			$produtos[] = [
				'ref' => $item['COD'],
				'saldo' => (int)$item['SLD_DISPONIVEL']
			];
		}
 
		// Monta o payload
		$payload = json_encode(['produtos' => $produtos]);

		// Configura a chamada cURL
		$ch = curl_init('https://portal.hobety.com.br/painel/data/produto/atualizar_estoque');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Authorization: Bearer OAlvLNTaPHEMtb2yikJu3Q7FGsIZxXYe',
			'Cookie: ci_session=uge53f4rc1ruo0gnklgh5u37jsodl0q0'
		]);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

		// Executa a chamada e captura a resposta
		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			echo 'Erro na requisição: ' . curl_error($ch);
		} else {
			echo 'Resposta da API: ' . $response;
		}

		curl_close($ch);
	}

	
	
	 
	public function cashback()
	{
		$this->load->model('Produto_model');
		$this->load->model('Cliente_model');
		
		// Gera os cashbacks originais
		$cashbacks = $this->Produto_model->gera_cashback();
		
		
		
		
		

		// Exclui cashbacks não atualizados (processo interno de limpeza)
		$this->Cliente_model->delete_cashbacks_nao_atualizados();
		
		// **Busca os clientes indexados por [codigo][loja]**
		$clientes_indexados = $this->Cliente_model->get_all_clientes_indexed_by_codigo_loja();
	
			
			
		
		// ------------------------------------------
		// 1) Agrupa/soma os cashbacks por pedido_id
		// ------------------------------------------
		$cashbacksAgrupados = [];
		foreach ($cashbacks as $cashback) {
			$pedidoId = $cashback['DOCUMENTO'];
			
			// Se ainda não existe chave para este pedido_id, cria
			if (!isset($cashbacksAgrupados[$pedidoId])) {
				$cashbacksAgrupados[$pedidoId] = $cashback;
			} else {
				// Se já existe, soma o valor ao que já temos
				$cashbacksAgrupados[$pedidoId]['CASHBACK'] += $cashback['CASHBACK'];
			}
		}

		// ----------------------------------
		// 2) Agora percorremos os *cashbacks já somados*
		// ----------------------------------
		foreach ($cashbacksAgrupados as $pedidoId => $cashback) {
			$cliente_codigo = $cashback['D2_CLIENTE'];
			$cliente_loja   = $cashback['D2_LOJA']; // <-- Nova informação

			// Verifica se existe esse cliente (código+loja) no array de clientes indexados
			if (!isset($clientes_indexados[$cliente_codigo][$cliente_loja])) {
				echo "Não encontrou o cliente ".$cashback['D2_CLIENTE']." - ".$cashback['NOME']." e loja ".$cashback['D2_LOJA']."<br>";
				echo "<hr>";
				continue; // Se não achar o cliente, pula
				
			}
			
			
 
			$cliente         = $clientes_indexados[$cliente_codigo][$cliente_loja];
			$cliente_id      = $cliente['cliente_id'];
			$valor_cashback  = $cashback['CASHBACK'];
			$emissao         = $cashback['DT_FAT'];

			// Converte a data de emissão para DateTime (formato original: d/m/Y)
			$emissaoDate = DateTime::createFromFormat('d/m/Y', $emissao);
			
			// Define período de validade do cashback
			$dataInicio = (clone $emissaoDate)->modify('first day of next month');
			$dataFim    = (clone $emissaoDate)->modify('last day of next month'); 
			
			// Converte para formato Y-m-d
			$dataInicioFormatada = $dataInicio->format('Y-m-d');
			$dataFimFormatada    = $dataFim->format('Y-m-d');

			// Conexão com o banco 'portal'
			$dbportal = $this->load->database('portal', TRUE);

			// Verifica se já existe um cashback para este pedido no BD
			$dbportal->select('*')
					 ->from('cliente_cashback')
					 ->where('pedido_id', $pedidoId);

			$query = $dbportal->get();
			$registroExistente = $query->row_array();

			if ($registroExistente) {
				// Se já existe, verifica se ainda não foi usado (status != 2)
				if ($registroExistente['status'] != 2) {
					// Atualiza valor + flag de atualizado
					$updateParams = [
						'valor'      => $valor_cashback,
						'atualizado' => 1,
						'data_inicio' => $dataInicioFormatada,
						'data_fim'    => $dataFimFormatada,
					];
					$dbportal->where('pedido_id', $pedidoId);
					if ($dbportal->update('cliente_cashback', $updateParams)) {
						echo "Pedido {$pedidoId} do cliente {$cliente['codigo']} - {$cliente['nome']} atualizado. Novo valor: {$valor_cashback}<br>";
					} else {
						echo "Erro ao atualizar o pedido {$pedidoId} do cliente {$cliente['nome']}<br>";
					}
				} else {
					// Se já estiver usado (status=2), não altera nada
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} já está usado (status=2). Não atualizado.<br>";
				}
			} else {
				// Se não existe registro, insere
				$insertParams = [
					'cliente_id'  => $cliente_id,
					'pedido_id'   => $pedidoId,
					'data'        => date('Y-m-d H:i:s'),
					'data_inicio' => $dataInicioFormatada,
					'data_fim'    => $dataFimFormatada,
					'valor'       => $valor_cashback,
					'status'      => 1,  // 1 = não usado
					'atualizado'  => 1
				];
				
				

				if ($dbportal->insert('cliente_cashback', $insertParams)) {
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} inserido com valor de {$valor_cashback}.<br>";
				} else {
					echo "Erro ao inserir o pedido {$pedidoId} do cliente {$cliente['nome']}.<br>";
				}
			}
			
			echo "<hr>";
		}
	}
	
	
	public function cashback_individual($pedido_id)
	{
		$this->load->model('Produto_model');
		$this->load->model('Cliente_model');
		
		// Gera os cashbacks originais
		$cashbacks = $this->Produto_model->gera_cashback_individual($pedido_id);
		
		print_r($cashbacks);
		
		

		// Exclui cashbacks não atualizados (processo interno de limpeza)
		$this->Cliente_model->delete_cashbacks_nao_atualizados();
		
		// **Busca os clientes indexados por [codigo][loja]**
		$clientes_indexados = $this->Cliente_model->get_all_clientes_indexed_by_codigo_loja();
	
			
			
		
		// ----------------------------------
		// 1) Agrupa/soma os cashbacks por pedido_id
		// ----------------------------------
		$cashbacksAgrupados = [];
		foreach ($cashbacks as $cashback) {
			$pedidoId = $cashback['DOCUMENTO'];
			
			// Se ainda não existe chave para este pedido_id, cria
			if (!isset($cashbacksAgrupados[$pedidoId])) {
				$cashbacksAgrupados[$pedidoId] = $cashback;
			} else {
				// Se já existe, soma o valor ao que já temos
				$cashbacksAgrupados[$pedidoId]['CASHBACK'] += $cashback['CASHBACK'];
			}
		}

		// ----------------------------------
		// 2) Agora percorremos os *cashbacks já somados*
		// ----------------------------------
		foreach ($cashbacksAgrupados as $pedidoId => $cashback) {
			$cliente_codigo = $cashback['D2_CLIENTE'];
			$cliente_loja   = $cashback['D2_LOJA']; // <-- Nova informação

			// Verifica se existe esse cliente (código+loja) no array de clientes indexados
			if (!isset($clientes_indexados[$cliente_codigo][$cliente_loja])) {
				echo "Não encontrou o cliente ".$cashback['D2_CLIENTE']." - ".$cashback['NOME']." e loja ".$cashback['D2_LOJA']."<br>";
				echo "<hr>";
				continue; // Se não achar o cliente, pula
				
			}
			
			
 
			$cliente         = $clientes_indexados[$cliente_codigo][$cliente_loja];
			$cliente_id      = $cliente['cliente_id'];
			$valor_cashback  = $cashback['CASHBACK'];
			$emissao         = $cashback['DT_FAT'];

			// Converte a data de emissão para DateTime (formato original: d/m/Y)
			$emissaoDate = DateTime::createFromFormat('d/m/Y', $emissao);
			
			// Define período de validade do cashback
			$dataInicio = (clone $emissaoDate)->modify('first day of next month');
			$dataFim    = (clone $emissaoDate)->modify('last day of next month'); 
			
			// Converte para formato Y-m-d
			$dataInicioFormatada = $dataInicio->format('Y-m-d');
			$dataFimFormatada    = $dataFim->format('Y-m-d');

			// Conexão com o banco 'portal'
			$dbportal = $this->load->database('portal', TRUE);

			// Verifica se já existe um cashback para este pedido no BD
			$dbportal->select('*')
					 ->from('cliente_cashback')
					 ->where('pedido_id', $pedidoId);

			$query = $dbportal->get();
			$registroExistente = $query->row_array();

			if ($registroExistente) {
				// Se já existe, verifica se ainda não foi usado (status != 2)
				if ($registroExistente['status'] != 2) {
					// Atualiza valor + flag de atualizado
					$updateParams = [
						'valor'      => $valor_cashback,
						'atualizado' => 1,
						'data_inicio' => $dataInicioFormatada,
						'data_fim'    => $dataFimFormatada,
					];
					$dbportal->where('pedido_id', $pedidoId);
					if ($dbportal->update('cliente_cashback', $updateParams)) {
						echo "Pedido {$pedidoId} do cliente {$cliente['codigo']} - {$cliente['nome']} atualizado. Novo valor: {$valor_cashback}<br>";
					} else {
						echo "Erro ao atualizar o pedido {$pedidoId} do cliente {$cliente['nome']}<br>";
					}
				} else {
					// Se já estiver usado (status=2), não altera nada
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} já está usado (status=2). Não atualizado.<br>";
				}
			} else {
				// Se não existe registro, insere
				$insertParams = [
					'cliente_id'  => $cliente_id,
					'pedido_id'   => $pedidoId,
					'data'        => date('Y-m-d H:i:s'),
					'data_inicio' => $dataInicioFormatada,
					'data_fim'    => $dataFimFormatada,
					'valor'       => $valor_cashback,
					'status'      => 1,  // 1 = não usado
					'atualizado'  => 1
				];
				
				

				if ($dbportal->insert('cliente_cashback', $insertParams)) {
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} inserido com valor de {$valor_cashback}.<br>";
				} else {
					echo "Erro ao inserir o pedido {$pedidoId} do cliente {$cliente['nome']}.<br>";
				}
			}
			
			echo "<hr>";
		}
	}
	
	public function lista_cashback_cliente($cliente)
	{
		$this->load->model('Produto_model');
		$this->load->model('Cliente_model');
		
		// Gera os cashbacks originais
		$cashbacks = $this->Produto_model->lista_cashback_cliente($cliente);
		
		echo json_encode($cashbacks);
		
		

	}
	
	
	public function cashback_cliente_individual($pedido_id)
	{
		$this->load->model('Produto_model');
		$this->load->model('Cliente_model');
		
		// Gera os cashbacks originais
		$cashbacks = $this->Produto_model->gera_cashback_individual($pedido_id);
		
		
		

		// Exclui cashbacks não atualizados (processo interno de limpeza)
		$this->Cliente_model->delete_cashbacks_nao_atualizados();
		
		// **Busca os clientes indexados por [codigo][loja]**
		$clientes_indexados = $this->Cliente_model->get_all_clientes_indexed_by_codigo_loja();
	
			
			
		
		// ----------------------------------
		// 1) Agrupa/soma os cashbacks por pedido_id
		// ----------------------------------
		$cashbacksAgrupados = [];
		foreach ($cashbacks as $cashback) {
			$pedidoId = $cashback['CJ_ZZIDWEB'];
			
			// Se ainda não existe chave para este pedido_id, cria
			if (!isset($cashbacksAgrupados[$pedidoId])) {
				$cashbacksAgrupados[$pedidoId] = $cashback;
			} else {
				// Se já existe, soma o valor ao que já temos
				$cashbacksAgrupados[$pedidoId]['CASHBACK'] += $cashback['CASHBACK'];
			}
		}

		// ----------------------------------
		// 2) Agora percorremos os *cashbacks já somados*
		// ----------------------------------
		foreach ($cashbacksAgrupados as $pedidoId => $cashback) {
			$cliente_codigo = $cashback['D2_CLIENTE'];
			$cliente_loja   = $cashback['D2_LOJA']; // <-- Nova informação

			// Verifica se existe esse cliente (código+loja) no array de clientes indexados
			if (!isset($clientes_indexados[$cliente_codigo][$cliente_loja])) {
				echo "Não encontrou o cliente ".$cashback['D2_CLIENTE']." - ".$cashback['NOME']." e loja ".$cashback['D2_LOJA']."<br>";
				echo "<hr>";
				continue; // Se não achar o cliente, pula
				
			}
			
			
 
			$cliente         = $clientes_indexados[$cliente_codigo][$cliente_loja];
			$cliente_id      = $cliente['cliente_id'];
			$valor_cashback  = $cashback['CASHBACK'];
			$emissao         = $cashback['EMISSAO'];

			// Converte a data de emissão para DateTime (formato original: d/m/Y)
			$emissaoDate = DateTime::createFromFormat('d/m/Y', $emissao);
			
			// Define período de validade do cashback
			$dataInicio = (clone $emissaoDate)->modify('first day of next month');
			$dataFim    = (clone $emissaoDate)->modify('last day of next month'); 
			
			// Converte para formato Y-m-d
			$dataInicioFormatada = $dataInicio->format('Y-m-d');
			$dataFimFormatada    = $dataFim->format('Y-m-d');

			// Conexão com o banco 'portal'
			$dbportal = $this->load->database('portal', TRUE);

			// Verifica se já existe um cashback para este pedido no BD
			$dbportal->select('*')
					 ->from('cliente_cashback')
					 ->where('pedido_id', $pedidoId);

			$query = $dbportal->get();
			$registroExistente = $query->row_array();

			if ($registroExistente) {
				// Se já existe, verifica se ainda não foi usado (status != 2)
				if ($registroExistente['status'] != 2) {
					// Atualiza valor + flag de atualizado
					$updateParams = [
						'valor'      => $valor_cashback,
						'atualizado' => 1,
						'data_inicio' => $dataInicioFormatada,
						'data_fim'    => $dataFimFormatada,
					];
					$dbportal->where('pedido_id', $pedidoId);
					if ($dbportal->update('cliente_cashback', $updateParams)) {
						echo "Pedido {$pedidoId} do cliente {$cliente['codigo']} - {$cliente['nome']} atualizado. Novo valor: {$valor_cashback}<br>";
					} else {
						echo "Erro ao atualizar o pedido {$pedidoId} do cliente {$cliente['nome']}<br>";
					}
				} else {
					// Se já estiver usado (status=2), não altera nada
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} já está usado (status=2). Não atualizado.<br>";
				}
			} else {
				// Se não existe registro, insere
				$insertParams = [
					'cliente_id'  => $cliente_id,
					'pedido_id'   => $pedidoId,
					'data'        => date('Y-m-d H:i:s'),
					'data_inicio' => $dataInicioFormatada,
					'data_fim'    => $dataFimFormatada,
					'valor'       => $valor_cashback,
					'status'      => 1,  // 1 = não usado
					'atualizado'  => 1
				];
				
				

				if ($dbportal->insert('cliente_cashback', $insertParams)) {
					echo "Pedido {$pedidoId} do cliente {$cliente['nome']} inserido com valor de {$valor_cashback}.<br>";
				} else {
					echo "Erro ao inserir o pedido {$pedidoId} do cliente {$cliente['nome']}.<br>";
				}
			}
			
			echo "<hr>";
		}
	}



	
	
    function pedidos()
    {
        
        $pedidos = $this->Pedido_model->get_all_pedidos();		
        
        foreach($pedidos as $pedido){
			//echo $pedido['pedido_id']."<br />";
			
			$produtos = $this->Produto_pedido_model->get_all_produtos_by_pedido_id($pedido['pedido_id']);
			
		
			$qtditens=0;
			foreach($produtos as $produto){
				$qtditens++;
			}
			
			
			if(!$pedido['pedido_codigo']){
				
				if($pedido['orcamento'] == 1){
					continue;
				}
					
			
				//API URL 
				//$url = 'http://192.141.117.12:59191/rest/HOBETY_ORC';
				$url = 'http://hobety.ddns.me:59191/rest/HOBETY_ORC';	
					
				//create a new cURL resource
				$ch = curl_init($url);

				//setup request to send json via POST
				$data = array(
					"CODCLI"   => $pedido['cliente_codigo'],
					"LOJA"     => $pedido['loja'],
					"IDWEB"    => $pedido['pedido_id'],
					"TABELAPRC"=> $pedido['tabela_codigo'],
					"OBS"      => $pedido['obs'],
					"QTDITENS" => $qtditens,
				);
				
				$i=1;
				
				foreach($produtos as $produto){
					
					
					$check = file_get_contents('https://portal.hobety.com.br/produtos/check_cashback/'.$produto['produto_id']);
					
					$array = json_decode($check, true);
					
					if ($array && isset($array['elegivel'])) {
						$cashback = $array['elegivel'] ? $produto['cashback'] : 0;
					} else {
						$cashback = 0; // valor padrão caso endpoint falhe
					}
					
					if($produto['qtd']){
						$total = $produto['qtd'] * $produto['preco'];
						$data[$i] = array(
							"CODPROD" => $produto['ref'],
							"QTD" => $produto['qtd'],
							"PRECO"=>$produto['preco'],
							"TOTALITEM"=>$total,
							'CK_ZZCHBCK'=>$cashback
						);
						$i++;
					}
					
					
				}
				
			    $payload = json_encode(array("PEDIDOWEB" => $data));
				
				
				//print_r($payload);
				echo "<br><br>";
				
				//print_r($payload);
				//exit();
			

				
				//attach encoded JSON string to the POST fields
				curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

				//set the content type to application/json
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

				//return response instead of outputting
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				//execute the POST request
				echo $result = curl_exec($ch);
				
				//echo "resultado: ";
				
				//echo $result."<br />";
				
				if (curl_errno($ch)) {
					//erro no retorno
					
					
				}
				$parts = explode("|", $result);
				
				//201 -> Sucesso
				//400 -> Erro
				//DUP -> ID JÁ EXISTENTE
				
				
				if(substr($result,12,3) == '201'){
					$params = array(
						'codigo' => substr($result,43,6) 
					);
					$this->Pedido_model->update_pedido($pedido['pedido_id'], $params);
				}else{
					$params = array(
						'codigo' => '000000',
					);
					$this->Pedido_model->update_pedido($pedido['pedido_id'], $params);
				}

				//close cURL resource
				curl_close($ch);
												
			}
			
			
	    }
		
		
		?>
			<script>
			
				window.onload = function() {
					if(!window.location.hash) {
						window.location.reload();
					}
				}
			
			</script>
		<?php
        
        
    }
	
	
	
	
	
	
	
	
    function visualiza_pedidos()
    {
        
        $pedidos = $this->Pedido_model->get_all_pedidos();		
        
        foreach($pedidos as $pedido){
			echo "<br><br>".$pedido['pedido_id']." - ".$pedido['cliente_codigo']." - ".$pedido['data']."<br />";
			
			$produtos = $this->Produto_pedido_model->get_all_produtos_by_pedido_id($pedido['pedido_id']);
			
		
			
			
			if(!$pedido['pedido_codigo']){
			
				
				foreach($produtos as $produto){
					$total = $produto['qtd'] * $produto['preco'];
					
					
					echo $produto['ref']." - ". $produto['qtd']." - ".$produto['preco']." - ".$total."<br>";
				}
				
												
			}
			
			
	    }
		
        
    }
	
	
	
	
	
	function pedido_individual()
    {
        
        $pedidos = $this->Pedido_model->get_all_pedidos_individual($this->uri->segment(3));		
        
        foreach($pedidos as $pedido){
			//echo $pedido['pedido_id']."<br />";
			
			$produtos = $this->Produto_pedido_model->get_all_produtos_by_pedido_id($pedido['pedido_id']);
			
		
			$qtditens=0;
			foreach($produtos as $produto){
				$qtditens++;
			}
			
	
				
			
				//API URL 
				//$url = 'http://192.141.117.12:59191/rest/HOBETY_ORC';
				$url = 'http://hobety.ddns.me:59191/rest/HOBETY_ORC';	
					
				//create a new cURL resource
				$ch = curl_init($url);

				//setup request to send json via POST
				$data = array(
					"CODCLI"   => $pedido['cliente_codigo'],
					"LOJA"     => "01",
					"IDWEB"    => $pedido['pedido_id'],
					"TABELAPRC"=> $pedido['tabela_codigo'],
					"OBS"      => $pedido['obs'],
					"QTDITENS" => $qtditens,
				);
				
				$i=1;
				
				foreach($produtos as $produto){
					$total = $produto['qtd'] * $produto['preco'];
					$data[$i] = array(
						"CODPROD" => $produto['ref'],
						"QTD" => $produto['qtd'],
						"PRECO"=>$produto['preco'],
						"TOTALITEM"=>$total,
					);
					$i++;
				}
				
			    $payload = json_encode(array("PEDIDOWEB" => $data));
				
				//print_r($payload);
				//echo "<br><br>";
				
				//print_r($payload);
				//exit();
			

				
				//attach encoded JSON string to the POST fields
				curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

				//set the content type to application/json
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));

				//return response instead of outputting
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

				//execute the POST request
				$result = curl_exec($ch);
				
				//echo "resultado: ";
				
				//echo $result."<br />";
				
				print_r($result);
				
				if (curl_errno($ch)) {
					//erro no retorno
					
					
				}
				$parts = explode("|", $result);
				
				//201 -> Sucesso
				//400 -> Erro
				//DUP -> ID JÁ EXISTENTE
				
				if(substr($result,12,3) == '201'){
					$params = array(
						'codigo' => substr($result,43,6),
						'erro' => 0,
					);
					$this->Pedido_model->update_pedido($pedido['pedido_id'], $params);
				}else{
					$params = array(
						'codigo' => '000000',
						'erro' => 1,
					);
					$this->Pedido_model->update_pedido($pedido['pedido_id'], $params);
				}

				//close cURL resource
				curl_close($ch);
												
			
			
			
	    }
		
		
		
        
        
    }

    
}
