<?php

 
class Api extends CI_Controller{
    function __construct()
    {
        parent::__construct();
		$this->load->model('Distribuidor_model');
    } 

    

    function distribuidor(){
		
		$distribuidores = $this->Distribuidor_model->get_distribuidores_totvs();
		echo "<pre>";
		//print_r($distribuidores);
		
		foreach($distribuidores as $distribuidor){
			
			$dist = $this->Distribuidor_model->get_distribuidor_portal_by_codigo($distribuidor['COD']);
			
			$dia = substr($distribuidor['DT_PRICOM'],0,2);
			$mes = substr($distribuidor['DT_PRICOM'],3,2);
			$ano = substr($distribuidor['DT_PRICOM'],6,4);
			$primeira_compra = $ano."-".$mes."-".$dia;
			
			$dia = substr($distribuidor['DT_ULCOMP'],0,2);
			$mes = substr($distribuidor['DT_ULCOMP'],3,2);
			$ano = substr($distribuidor['DT_ULCOMP'],6,4);
			$ultima_compra = $ano."-".$mes."-".$dia;
			
			$params = array(
					'nome_completo' => $distribuidor['NOME'],
					'nome' => $distribuidor['NOME_REDUZIDO'],
					'cnpj' => $distribuidor['CNPJCPF'],
					'vendedor' => $distribuidor['VENDEDOR'],
					'e-mail' => '',
					'whatsapp' => $distribuidor['DDD'].$distribuidor['TELEFONE'],
					'endereco' => $distribuidor['ENDERECO'],
					'numero' => '',
					'bairro' => $distribuidor['BAIRRO'],
					'estado' => $distribuidor['UF'],
					'cidade' => $distribuidor['MUNICIPIO'],
					'complemento' => '',
					'cep' => $distribuidor['CEP'],
					'ativo' => 1,
					'valor_faturamento_desc' => $distribuidor['VLR_FATDESC'],
					'valor_faturamento_bruto' => $distribuidor['VLR_FATBRU'],
					'media_compra' => $distribuidor['MEDIA_COMPRA'],
					'qtd_item' => $distribuidor['QTD_ITEM'],
					'data_primeira_compra' => $primeira_compra,
					'data_ultima_compra' => $ultima_compra,
					'vlr_prd_bruto' => $distribuidor['VLR_PRD_BRUTO'],
					'atividade' => $distribuidor['ATIVIDADE'],
			);
			if($dist){
				echo $distribuidor['COD']." atualizado no portal<br>"; 
				$this->Distribuidor_model->update_distribuidor_portal($dist['distribuidor_id'], $params);
			}else{
				echo $distribuidor['COD']." cadastrado no portal<br>";
				$this->Distribuidor_model->add_distribuidor_portal($params);
			}
		}
		
	}
	
	
	
    
}
